/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.CongestionControl;
import io.aeron.driver.CongestionControlUtil;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.PerImageIndicator;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class CubicCongestionControl
implements CongestionControl {
    private static final boolean RTT_MEASUREMENT = false;
    private static final long RTT_MEASUREMENT_TIMEOUT = TimeUnit.MILLISECONDS.toNanos(10L);
    private static final long RTT_MAX_TIMEOUT = TimeUnit.SECONDS.toNanos(1L);
    private static final int MAX_OUTSTANDING_RTT_MEASUREMENTS = 1;
    private static final boolean TCP_MODE = false;
    private static final double C = 0.4;
    private static final double B = 0.2;
    private final int minWindow;
    private final int mtu;
    private final int maxCwnd;
    private long lastLossTimestamp;
    private long lastUpdateTimestamp;
    private long lastRttTimestamp = 0L;
    private long windowUpdateTimeout;
    private long rttInNanos;
    private double k;
    private int cwnd;
    private int w_max;
    private int outstandingRttMeasurements = 0;
    private AtomicCounter rttIndicator;
    private AtomicCounter windowIndicator;

    CubicCongestionControl(long registrationId, UdpChannel udpChannel, int streamId, int sessionId, int termLength, int senderMtuLength, NanoClock clock, MediaDriver.Context context, CountersManager countersManager) {
        this.mtu = senderMtuLength;
        this.minWindow = senderMtuLength;
        int maxWindow = context.initialWindowLength();
        this.maxCwnd = maxWindow / this.mtu;
        this.cwnd = 1;
        this.w_max = this.maxCwnd;
        this.k = Math.cbrt((double)this.w_max * 0.2 / 0.4);
        this.windowUpdateTimeout = this.rttInNanos = TimeUnit.MICROSECONDS.toNanos(100L);
        this.rttIndicator = PerImageIndicator.allocate("rcv-cc-cubic-rtt", countersManager, registrationId, sessionId, streamId, udpChannel.originalUriString(), "");
        this.windowIndicator = PerImageIndicator.allocate("rcv-cc-cubic-wnd", countersManager, registrationId, sessionId, streamId, udpChannel.originalUriString(), "");
        this.rttIndicator.setOrdered(0L);
        this.windowIndicator.setOrdered((long)this.minWindow);
        this.lastUpdateTimestamp = this.lastLossTimestamp = clock.nanoTime();
    }

    @Override
    public boolean shouldMeasureRtt(long now) {
        boolean result = false;
        return result;
    }

    @Override
    public void onRttMeasurement(long now, long rttInNanos, InetSocketAddress srcAddress) {
        --this.outstandingRttMeasurements;
        this.lastRttTimestamp = now;
        this.rttInNanos = rttInNanos;
        this.rttIndicator.setOrdered(rttInNanos);
    }

    @Override
    public long onTrackRebuild(long now, long newConsumptiopnPosition, long lastSmPosition, long hwmPosition, long startingRebuildPosition, long endingRebuildPosition, boolean lossOccurred) {
        boolean forceStatusMessage = false;
        if (lossOccurred) {
            this.w_max = this.cwnd;
            this.k = Math.cbrt((double)this.w_max * 0.2 / 0.4);
            this.cwnd = Math.min(1, (int)((double)this.cwnd * 0.8));
            this.lastLossTimestamp = now;
            forceStatusMessage = true;
        } else if (this.cwnd < this.maxCwnd && now > this.lastUpdateTimestamp + this.windowUpdateTimeout) {
            double durationSinceDecr = (double)(now - this.lastLossTimestamp) / (double)TimeUnit.SECONDS.toNanos(1L);
            double diffToK = durationSinceDecr - this.k;
            double incr = 0.4 * diffToK * diffToK * diffToK;
            this.cwnd = Math.min(this.maxCwnd, this.w_max + (int)incr);
            this.lastUpdateTimestamp = now;
        }
        int window = this.cwnd * this.mtu;
        this.windowIndicator.setOrdered((long)window);
        return CongestionControlUtil.packOutcome(window, forceStatusMessage);
    }

    @Override
    public int initialWindowLength() {
        return this.minWindow;
    }

    @Override
    public void close() {
        CloseHelper.close((AutoCloseable)this.rttIndicator);
        CloseHelper.close((AutoCloseable)this.windowIndicator);
    }
}

