/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.DebugChannelEndpointConfiguration;
import io.aeron.driver.ext.LossGenerator;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

public class DebugSendChannelEndpoint
extends SendChannelEndpoint {
    private final LossGenerator dataLossGenerator;
    private final LossGenerator controlLossGenerator;
    private final UnsafeBuffer dataBuffer = new UnsafeBuffer(ByteBuffer.allocate(0));

    public DebugSendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context) {
        this(udpChannel, statusIndicator, context, DebugChannelEndpointConfiguration.sendDataLossGeneratorSupplier(), DebugChannelEndpointConfiguration.sendControlLossGeneratorSupplier());
    }

    public DebugSendChannelEndpoint(UdpChannel udpChannel, AtomicCounter statusIndicator, MediaDriver.Context context, LossGenerator dataLossGenerator, LossGenerator controlLossGenerator) {
        super(udpChannel, statusIndicator, context);
        this.dataLossGenerator = dataLossGenerator;
        this.controlLossGenerator = controlLossGenerator;
    }

    @Override
    public int send(ByteBuffer buffer) {
        int result = buffer.remaining();
        this.dataBuffer.wrap(buffer, buffer.position(), buffer.remaining());
        if (!this.dataLossGenerator.shouldDropFrame(this.connectAddress, this.dataBuffer, buffer.remaining())) {
            result = super.send(buffer);
        }
        return result;
    }

    @Override
    public void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress srcAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, (UnsafeBuffer)msg, msg.frameLength())) {
            super.onStatusMessage(msg, srcAddress);
        }
    }

    @Override
    public void onNakMessage(NakFlyweight msg, InetSocketAddress srcAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, (UnsafeBuffer)msg, msg.frameLength())) {
            super.onNakMessage(msg, srcAddress);
        }
    }

    @Override
    public void onRttMeasurement(RttMeasurementFlyweight msg, InetSocketAddress srcAddress) {
        if (!this.controlLossGenerator.shouldDropFrame(srcAddress, (UnsafeBuffer)msg, msg.frameLength())) {
            super.onRttMeasurement(msg, srcAddress);
        }
    }
}

