/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.Configuration;
import io.aeron.driver.media.NetworkUtil;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class ControlTransportPoller
extends UdpTransportPoller {
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer unsafeBuffer;
    private final NakFlyweight nakMessage;
    private final StatusMessageFlyweight statusMessage;
    private final RttMeasurementFlyweight rttMeasurement;
    private SendChannelEndpoint[] transports = new SendChannelEndpoint[0];

    public ControlTransportPoller() {
        this.byteBuffer = NetworkUtil.allocateDirectAlignedAndPadded(Configuration.MTU_LENGTH, 128);
        this.unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
        this.nakMessage = new NakFlyweight(this.unsafeBuffer);
        this.statusMessage = new StatusMessageFlyweight(this.unsafeBuffer);
        this.rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    }

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.transports.length <= 5) {
                for (SendChannelEndpoint transport : this.transports) {
                    bytesReceived += this.poll(transport);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += this.poll((SendChannelEndpoint)keys[i].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((SendChannelEndpoint)transport);
    }

    public SelectionKey registerForRead(SendChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            this.transports = (SendChannelEndpoint[])ArrayUtil.add((Object[])this.transports, (Object)transport);
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((SendChannelEndpoint)transport);
    }

    public void cancelRead(SendChannelEndpoint transport) {
        this.transports = (SendChannelEndpoint[])ArrayUtil.remove((Object[])this.transports, (Object)transport);
    }

    private int poll(SendChannelEndpoint channelEndpoint) {
        int byteReceived = 0;
        InetSocketAddress srcAddress = channelEndpoint.receive(this.byteBuffer);
        if (null != srcAddress && channelEndpoint.isValidFrame(this.unsafeBuffer, byteReceived = this.byteBuffer.position())) {
            switch (FrameDescriptor.frameType((UnsafeBuffer)this.unsafeBuffer, (int)0)) {
                case 2: {
                    channelEndpoint.onNakMessage(this.nakMessage, srcAddress);
                    break;
                }
                case 3: {
                    channelEndpoint.onStatusMessage(this.statusMessage, srcAddress);
                    break;
                }
                case 6: {
                    channelEndpoint.onRttMeasurement(this.rttMeasurement, srcAddress);
                }
            }
        }
        return byteReceived;
    }
}

