/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.BufferUtil;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class DataTransportPoller
extends UdpTransportPoller {
    private static final int MAX_UDP_PACKET = 65536;
    private final ByteBuffer byteBuffer;
    private final UnsafeBuffer unsafeBuffer;
    private final DataHeaderFlyweight dataMessage;
    private final SetupFlyweight setupMessage;
    private final RttMeasurementFlyweight rttMeasurement;
    private ReceiveChannelEndpoint[] transports = new ReceiveChannelEndpoint[0];

    public DataTransportPoller() {
        this.byteBuffer = BufferUtil.allocateDirectAligned((int)65536, (int)128);
        this.unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
        this.dataMessage = new DataHeaderFlyweight(this.unsafeBuffer);
        this.setupMessage = new SetupFlyweight(this.unsafeBuffer);
        this.rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    }

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.transports.length <= 5) {
                for (ReceiveChannelEndpoint transport : this.transports) {
                    bytesReceived += this.poll(transport);
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += this.poll((ReceiveChannelEndpoint)keys[i].attachment());
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((ReceiveChannelEndpoint)transport);
    }

    public SelectionKey registerForRead(ReceiveChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            this.transports = (ReceiveChannelEndpoint[])ArrayUtil.add((Object[])this.transports, (Object)transport);
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((ReceiveChannelEndpoint)transport);
    }

    public void cancelRead(ReceiveChannelEndpoint transport) {
        this.transports = (ReceiveChannelEndpoint[])ArrayUtil.remove((Object[])this.transports, (Object)transport);
    }

    private int poll(ReceiveChannelEndpoint channelEndpoint) {
        int length;
        int bytesReceived = 0;
        InetSocketAddress srcAddress = channelEndpoint.receive(this.byteBuffer);
        if (null != srcAddress && channelEndpoint.isValidFrame(this.unsafeBuffer, length = this.byteBuffer.position())) {
            switch (FrameDescriptor.frameType((UnsafeBuffer)this.unsafeBuffer, (int)0)) {
                case 0: 
                case 1: {
                    bytesReceived = channelEndpoint.onDataPacket(this.dataMessage, this.unsafeBuffer, length, srcAddress);
                    break;
                }
                case 5: {
                    channelEndpoint.onSetupMessage(this.setupMessage, this.unsafeBuffer, srcAddress);
                    break;
                }
                case 6: {
                    channelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, srcAddress);
                }
            }
        }
        return bytesReceived;
    }
}

