/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.ErrorCode;
import io.aeron.driver.AeronClient;
import io.aeron.driver.ClientCommandAdapter;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.CounterLink;
import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.DriverNameResolver;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControl;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.IpcSubscriptionLink;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.NetworkPublicationThreadLocals;
import io.aeron.driver.NetworkSubscriptionLink;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.PublicationLink;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.RetransmitHandler;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.SessionKey;
import io.aeron.driver.SpySubscriptionLink;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.ClientHeartbeatTimestamp;
import io.aeron.driver.status.PublisherLimit;
import io.aeron.driver.status.PublisherPos;
import io.aeron.driver.status.ReceiveChannelStatus;
import io.aeron.driver.status.ReceiveLocalSocketAddress;
import io.aeron.driver.status.ReceiverHwm;
import io.aeron.driver.status.ReceiverPos;
import io.aeron.driver.status.SendChannelStatus;
import io.aeron.driver.status.SendLocalSocketAddress;
import io.aeron.driver.status.SenderBpe;
import io.aeron.driver.status.SenderLimit;
import io.aeron.driver.status.SenderPos;
import io.aeron.driver.status.SubscriberPos;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.exceptions.ControlProtocolException;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public final class DriverConductor
implements Agent {
    private static final long CLOCK_UPDATE_DURATION_NS = TimeUnit.MILLISECONDS.toNanos(1L);
    private int nextSessionId = BitUtil.generateRandomisedId();
    private final long timerIntervalNs;
    private final long clientLivenessTimeoutNs;
    private final long statusMessageTimeoutNs;
    private long timeOfLastToDriverPositionChangeNs;
    private long lastConsumerCommandPosition;
    private long timeOfLastTimerCheckNs;
    private long clockUpdateDeadlineNs;
    private final MediaDriver.Context ctx;
    private final LogFactory logFactory;
    private final ReceiverProxy receiverProxy;
    private final SenderProxy senderProxy;
    private final ClientProxy clientProxy;
    private final RingBuffer toDriverCommands;
    private final ClientCommandAdapter clientCommandAdapter;
    private final ManyToOneConcurrentArrayQueue<Runnable> driverCmdQueue;
    private final Object2ObjectHashMap<String, SendChannelEndpoint> sendChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final Object2ObjectHashMap<String, ReceiveChannelEndpoint> receiveChannelEndpointByChannelMap = new Object2ObjectHashMap();
    private final ArrayList<NetworkPublication> networkPublications = new ArrayList();
    private final ArrayList<IpcPublication> ipcPublications = new ArrayList();
    private final ArrayList<PublicationImage> publicationImages = new ArrayList();
    private final ArrayList<PublicationLink> publicationLinks = new ArrayList();
    private final ArrayList<SubscriptionLink> subscriptionLinks = new ArrayList();
    private final ArrayList<CounterLink> counterLinks = new ArrayList();
    private final ArrayList<AeronClient> clients = new ArrayList();
    private final ObjectHashSet<SessionKey> activeSessionSet = new ObjectHashSet();
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final CachedEpochClock cachedEpochClock;
    private final CachedNanoClock cachedNanoClock;
    private final CountersManager countersManager;
    private final NetworkPublicationThreadLocals networkPublicationThreadLocals = new NetworkPublicationThreadLocals();
    private final MutableDirectBuffer tempBuffer;
    private final DataHeaderFlyweight defaultDataHeader = new DataHeaderFlyweight(DataHeaderFlyweight.createDefaultHeader((int)0, (int)0, (int)0));
    private final NameResolver nameResolver;
    private final DriverNameResolver driverNameResolver;

    DriverConductor(MediaDriver.Context ctx) {
        this.ctx = ctx;
        this.timerIntervalNs = ctx.timerIntervalNs();
        this.clientLivenessTimeoutNs = ctx.clientLivenessTimeoutNs();
        this.statusMessageTimeoutNs = ctx.statusMessageTimeoutNs();
        this.driverCmdQueue = ctx.driverCommandQueue();
        this.receiverProxy = ctx.receiverProxy();
        this.senderProxy = ctx.senderProxy();
        this.logFactory = ctx.logFactory();
        this.epochClock = ctx.epochClock();
        this.nanoClock = ctx.nanoClock();
        this.cachedEpochClock = ctx.cachedEpochClock();
        this.cachedNanoClock = ctx.cachedNanoClock();
        this.toDriverCommands = ctx.toDriverCommands();
        this.clientProxy = ctx.clientProxy();
        this.tempBuffer = ctx.tempBuffer();
        this.countersManager = ctx.countersManager();
        if (null == ctx.resolverInterface()) {
            this.driverNameResolver = null;
            this.nameResolver = ctx.nameResolver();
        } else {
            this.driverNameResolver = new DriverNameResolver(ctx);
            this.nameResolver = this.driverNameResolver;
        }
        this.clientCommandAdapter = new ClientCommandAdapter(ctx.systemCounters().get(SystemCounterDescriptor.ERRORS), ctx.errorHandler(), this.toDriverCommands, this.clientProxy, this);
        ctx.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES).appendToLabel(": driverName=").appendToLabel(ctx.resolverName()).appendToLabel(" hostname=").appendToLabel(DriverNameResolver.getCanonicalName());
        long nowNs = this.nanoClock.nanoTime();
        this.cachedNanoClock.update(nowNs);
        this.cachedEpochClock.update(this.epochClock.time());
        this.timeOfLastTimerCheckNs = nowNs;
        this.timeOfLastToDriverPositionChangeNs = nowNs;
        this.lastConsumerCommandPosition = this.toDriverCommands.consumerPosition();
    }

    public void onClose() {
        CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)this.driverNameResolver);
        this.publicationImages.forEach(PublicationImage::free);
        this.networkPublications.forEach(NetworkPublication::free);
        this.ipcPublications.forEach(IpcPublication::free);
        this.toDriverCommands.consumerHeartbeatTime(-1L);
        this.ctx.close();
    }

    public String roleName() {
        return "driver-conductor";
    }

    public int doWork() {
        long nowNs = this.nanoClock.nanoTime();
        this.updateClocks(nowNs);
        int workCount = 0;
        workCount += this.processTimers(nowNs);
        workCount += this.clientCommandAdapter.receive();
        workCount += this.driverCmdQueue.drain(Runnable::run, 10);
        workCount += this.trackStreamPositions(workCount, nowNs);
        return workCount += this.nameResolver.doWork(this.cachedEpochClock.time());
    }

    void onCreatePublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int initialTermOffset, int termBufferLength, int senderMtuLength, int transportIndex, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, ReceiveChannelEndpoint channelEndpoint) {
        Configuration.validateMtuLength(senderMtuLength);
        Configuration.validateInitialWindowLength(this.ctx.initialWindowLength(), senderMtuLength);
        long joinPosition = LogBufferDescriptor.computePosition((int)activeTermId, (int)initialTermOffset, (int)LogBufferDescriptor.positionBitsToShift((int)termBufferLength), (int)initialTermId);
        ArrayList<SubscriberPosition> subscriberPositions = this.createSubscriberPositions(sessionId, streamId, channelEndpoint, joinPosition);
        if (subscriberPositions.size() > 0) {
            UdpChannel udpChannel = channelEndpoint.udpChannel();
            String channel = udpChannel.originalUriString();
            long registrationId = this.toDriverCommands.nextCorrelationId();
            RawLog rawLog = this.newPublicationImageLog(sessionId, streamId, initialTermId, termBufferLength, DriverConductor.isOldestSubscriptionSparse(subscriberPositions), senderMtuLength, registrationId);
            CongestionControl congestionControl = this.ctx.congestionControlSupplier().newInstance(registrationId, udpChannel, streamId, sessionId, termBufferLength, senderMtuLength, controlAddress, sourceAddress, (NanoClock)this.cachedNanoClock, this.ctx, this.countersManager);
            CommonContext.InferableBoolean groupSubscription = subscriberPositions.get(0).subscription().group();
            boolean treatAsMulticast = groupSubscription == CommonContext.InferableBoolean.INFER ? udpChannel.isMulticast() : groupSubscription == CommonContext.InferableBoolean.FORCE_TRUE;
            FeedbackDelayGenerator feedbackDelayGenerator = treatAsMulticast ? this.ctx.multicastFeedbackDelayGenerator() : this.ctx.unicastFeedbackDelayGenerator();
            PublicationImage image = new PublicationImage(registrationId, this.ctx, channelEndpoint, transportIndex, controlAddress, sessionId, streamId, initialTermId, activeTermId, initialTermOffset, rawLog, feedbackDelayGenerator, subscriberPositions, (Position)ReceiverHwm.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel), (Position)ReceiverPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel), sourceAddress, congestionControl);
            this.publicationImages.add(image);
            this.receiverProxy.newPublicationImage(channelEndpoint, image);
            String sourceIdentity = Configuration.sourceIdentity(sourceAddress);
            int size = subscriberPositions.size();
            for (int i = 0; i < size; ++i) {
                SubscriberPosition position = subscriberPositions.get(i);
                position.addLink(image);
                this.clientProxy.onAvailableImage(registrationId, streamId, sessionId, position.subscription().registrationId(), position.positionCounterId(), rawLog.fileName(), sourceIdentity);
            }
        }
    }

    void onChannelEndpointError(long statusIndicatorId, Exception ex) {
        String errorMessage = ex.getClass().getSimpleName() + " : " + ex.getMessage();
        this.clientProxy.onError(statusIndicatorId, ErrorCode.CHANNEL_ENDPOINT_ERROR, errorMessage);
    }

    void onReResolveEndpoint(String endpoint, SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        try {
            InetSocketAddress newAddress = UdpChannel.resolve(endpoint, "endpoint", true, this.nameResolver);
            if (!address.equals(newAddress)) {
                this.senderProxy.onResolutionChange(channelEndpoint, endpoint, newAddress);
            }
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    void onReResolveControl(String control, UdpChannel udpChannel, ReceiveChannelEndpoint channelEndpoint, InetSocketAddress address) {
        try {
            InetSocketAddress newAddress = UdpChannel.resolve(control, "control", true, this.nameResolver);
            if (!address.equals(newAddress)) {
                this.receiverProxy.onResolutionChange(channelEndpoint, udpChannel, newAddress);
            }
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    IpcPublication getSharedIpcPublication(long streamId) {
        return DriverConductor.findSharedIpcPublication(this.ipcPublications, streamId);
    }

    IpcPublication getIpcPublication(long registrationId) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (publication.registrationId() != registrationId) continue;
            return publication;
        }
        return null;
    }

    NetworkPublication findNetworkPublicationByTag(long tag) {
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            long publicationTag = publication.tag();
            if (publicationTag != tag || publicationTag == -1L) continue;
            return publication;
        }
        return null;
    }

    IpcPublication findIpcPublicationByTag(long tag) {
        int size = this.ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            long publicationTag = publication.tag();
            if (publicationTag != tag || publicationTag == -1L) continue;
            return publication;
        }
        return null;
    }

    void onAddNetworkPublication(String channel, int streamId, long correlationId, long clientId, boolean isExclusive) {
        UdpChannel udpChannel = UdpChannel.parse(channel, this.nameResolver);
        ChannelUri channelUri = udpChannel.channelUri();
        PublicationParams params = PublicationParams.getPublicationParams(channelUri, this.ctx, this, isExclusive, false);
        PublicationParams.validateMtuForMaxMessage(params);
        SendChannelEndpoint channelEndpoint = this.getOrCreateSendChannelEndpoint(udpChannel, correlationId);
        NetworkPublication publication = null;
        if (!isExclusive) {
            publication = DriverConductor.findPublication(this.networkPublications, streamId, channelEndpoint);
        }
        if (null == publication) {
            if (params.hasSessionId) {
                this.checkForSessionClash(params.sessionId, streamId, udpChannel.canonicalForm());
            }
            publication = this.newNetworkPublication(correlationId, clientId, streamId, channel, udpChannel, channelEndpoint, params, isExclusive);
        } else {
            PublicationParams.confirmMatch(channelUri, params, publication.rawLog(), publication.sessionId());
            PublicationParams.validateSpiesSimulateConnection(params, publication.spiesSimulateConnection());
        }
        this.publicationLinks.add(new PublicationLink(correlationId, this.getOrAddClient(clientId), publication));
        this.clientProxy.onPublicationReady(correlationId, publication.registrationId(), streamId, publication.sessionId(), publication.rawLog().fileName(), publication.publisherLimitId(), channelEndpoint.statusIndicatorCounterId(), isExclusive);
    }

    void cleanupSpies(NetworkPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(publication)) continue;
            this.clientProxy.onUnavailableImage(publication.registrationId(), link.registrationId(), publication.streamId(), publication.channel());
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    void notifyUnavailableImageLink(long resourceId, SubscriptionLink link) {
        this.clientProxy.onUnavailableImage(resourceId, link.registrationId(), link.streamId(), link.channel());
    }

    void notifyAvailableImageLink(long resourceId, int sessionId, SubscriptionLink link, int positionCounterId, long joinPosition, String logFileName, String sourceIdentity) {
        this.countersManager.setCounterValue(positionCounterId, joinPosition);
        int streamId = link.streamId();
        this.clientProxy.onAvailableImage(resourceId, streamId, sessionId, link.registrationId(), positionCounterId, logFileName, sourceIdentity);
    }

    void cleanupPublication(NetworkPublication publication) {
        this.senderProxy.removeNetworkPublication(publication);
        SendChannelEndpoint channelEndpoint = publication.channelEndpoint();
        if (channelEndpoint.shouldBeClosed()) {
            this.senderProxy.closeSendChannelEndpoint(channelEndpoint);
            channelEndpoint.closeStatusIndicator();
            this.sendChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
        }
        String channel = channelEndpoint.udpChannel().canonicalForm();
        this.activeSessionSet.remove((Object)new SessionKey(publication.sessionId(), publication.streamId(), channel));
    }

    void cleanupSubscriptionLink(SubscriptionLink subscription) {
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            if (subscription.hasSessionId()) {
                if (0L == channelEndpoint.decRefToStreamAndSession(subscription.streamId(), subscription.sessionId())) {
                    this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
                }
            } else if (0 == channelEndpoint.decRefToStream(subscription.streamId())) {
                this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
            }
            if (channelEndpoint.shouldBeClosed()) {
                channelEndpoint.closeStatusIndicator();
                this.receiveChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
            }
        }
    }

    void transitionToLinger(PublicationImage image) {
        boolean rejoin = true;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(image)) continue;
            rejoin = link.isRejoin();
            this.clientProxy.onUnavailableImage(image.correlationId(), link.registrationId(), image.streamId(), image.channel());
        }
        if (rejoin) {
            this.receiverProxy.removeCoolDown(image.channelEndpoint(), image.sessionId(), image.streamId());
        }
    }

    void transitionToLinger(IpcPublication publication) {
        this.activeSessionSet.remove((Object)new SessionKey(publication.sessionId(), publication.streamId(), "ipc"));
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (!link.isLinked(publication)) continue;
            this.clientProxy.onUnavailableImage(publication.registrationId(), link.registrationId(), publication.streamId(), "aeron:ipc");
        }
    }

    void cleanupImage(PublicationImage image) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(image);
        }
    }

    void cleanupIpcPublication(IpcPublication publication) {
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            this.subscriptionLinks.get(i).unlink(publication);
        }
    }

    void clientTimeout(long clientId) {
        this.clientProxy.onClientTimeout(clientId);
    }

    void unavailableCounter(long registrationId, int counterId) {
        this.clientProxy.onUnavailableCounter(registrationId, counterId);
    }

    void onAddIpcPublication(String channel, int streamId, long correlationId, long clientId, boolean isExclusive) {
        IpcPublication ipcPublication = this.getOrAddIpcPublication(correlationId, clientId, streamId, channel, isExclusive);
        this.publicationLinks.add(new PublicationLink(correlationId, this.getOrAddClient(clientId), ipcPublication));
        ArrayList<SubscriberPosition> subscriberPositions = this.linkIpcSubscriptions(ipcPublication);
        this.clientProxy.onPublicationReady(correlationId, ipcPublication.registrationId(), streamId, ipcPublication.sessionId(), ipcPublication.rawLog().fileName(), ipcPublication.publisherLimitId(), -1, isExclusive);
        int size = subscriberPositions.size();
        for (int i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = subscriberPositions.get(i);
            this.clientProxy.onAvailableImage(ipcPublication.registrationId(), streamId, ipcPublication.sessionId(), subscriberPosition.subscription().registrationId, subscriberPosition.position().id(), ipcPublication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onRemovePublication(long registrationId, long correlationId) {
        PublicationLink publicationLink = null;
        ArrayList<PublicationLink> publicationLinks = this.publicationLinks;
        int size = publicationLinks.size();
        for (int i = 0; i < size; ++i) {
            PublicationLink publication = publicationLinks.get(i);
            if (registrationId != publication.registrationId()) continue;
            publicationLink = publication;
            ArrayListUtil.fastUnorderedRemove(publicationLinks, (int)i);
            break;
        }
        if (null == publicationLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        publicationLink.close();
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddSendDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        ChannelUri channelUri = ChannelUri.parse((CharSequence)destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(channelUri, this.nameResolver);
        this.senderProxy.addDestination(sendChannelEndpoint, channelUri, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveSendDestination(long registrationId, String destinationChannel, long correlationId) {
        SendChannelEndpoint sendChannelEndpoint = null;
        int size = this.networkPublications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (registrationId != publication.registrationId()) continue;
            sendChannelEndpoint = publication.channelEndpoint();
            break;
        }
        if (null == sendChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_PUBLICATION, "unknown publication: " + registrationId);
        }
        sendChannelEndpoint.validateAllowsManualControl();
        ChannelUri channelUri = ChannelUri.parse((CharSequence)destinationChannel);
        InetSocketAddress dstAddress = UdpChannel.destinationAddress(channelUri, this.nameResolver);
        this.senderProxy.removeDestination(sendChannelEndpoint, channelUri, dstAddress);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onAddNetworkSubscription(String channel, int streamId, long registrationId, long clientId) {
        UdpChannel udpChannel = UdpChannel.parse(channel, this.nameResolver);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        this.checkForClashingSubscription(params, udpChannel, streamId);
        ReceiveChannelEndpoint channelEndpoint = this.getOrCreateReceiveChannelEndpoint(udpChannel, registrationId);
        if (params.hasSessionId) {
            if (1L == channelEndpoint.incRefToStreamAndSession(streamId, params.sessionId)) {
                this.receiverProxy.addSubscription(channelEndpoint, streamId, params.sessionId);
            }
        } else if (1 == channelEndpoint.incRefToStream(streamId)) {
            this.receiverProxy.addSubscription(channelEndpoint, streamId);
        }
        AeronClient client = this.getOrAddClient(clientId);
        NetworkSubscriptionLink subscription = new NetworkSubscriptionLink(registrationId, channelEndpoint, streamId, channel, client, params);
        this.subscriptionLinks.add(subscription);
        this.clientProxy.onSubscriptionReady(registrationId, channelEndpoint.statusIndicatorCounterId());
        this.linkMatchingImages(subscription);
    }

    void onAddIpcSubscription(String channel, int streamId, long registrationId, long clientId) {
        int i;
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(ChannelUri.parse((CharSequence)channel), this.ctx);
        IpcSubscriptionLink subscriptionLink = new IpcSubscriptionLink(registrationId, streamId, channel, this.getOrAddClient(clientId), params);
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        this.subscriptionLinks.add(subscriptionLink);
        int size = this.ipcPublications.size();
        for (i = 0; i < size; ++i) {
            IpcPublication publication = this.ipcPublications.get(i);
            if (IpcPublication.State.ACTIVE != publication.state() || !subscriptionLink.matches(publication)) continue;
            Position subPos = this.linkIpcSubscription(publication, subscriptionLink);
            subscriberPositions.add(new SubscriberPosition(subscriptionLink, publication, subPos));
        }
        this.clientProxy.onSubscriptionReady(registrationId, -1);
        size = subscriberPositions.size();
        for (i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = (SubscriberPosition)subscriberPositions.get(i);
            IpcPublication publication = (IpcPublication)subscriberPosition.subscribable();
            this.clientProxy.onAvailableImage(publication.registrationId(), streamId, publication.sessionId(), registrationId, subscriberPosition.position().id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onAddSpySubscription(String channel, int streamId, long registrationId, long clientId) {
        int i;
        UdpChannel udpChannel = UdpChannel.parse(channel, this.nameResolver);
        AeronClient client = this.getOrAddClient(clientId);
        SubscriptionParams params = SubscriptionParams.getSubscriptionParams(udpChannel.channelUri(), this.ctx);
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        SpySubscriptionLink subscriptionLink = new SpySubscriptionLink(registrationId, udpChannel, streamId, client, params);
        this.subscriptionLinks.add(subscriptionLink);
        int size = this.networkPublications.size();
        for (i = 0; i < size; ++i) {
            NetworkPublication publication = this.networkPublications.get(i);
            if (NetworkPublication.State.ACTIVE != publication.state() || !subscriptionLink.matches(publication)) continue;
            Position subPos = this.linkSpy(publication, subscriptionLink);
            subscriberPositions.add(new SubscriberPosition(subscriptionLink, publication, subPos));
        }
        this.clientProxy.onSubscriptionReady(registrationId, -1);
        size = subscriberPositions.size();
        for (i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = (SubscriberPosition)subscriberPositions.get(i);
            NetworkPublication publication = (NetworkPublication)subscriberPosition.subscribable();
            this.clientProxy.onAvailableImage(publication.registrationId(), streamId, publication.sessionId(), registrationId, subscriberPosition.position().id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    void onRemoveSubscription(long registrationId, long correlationId) {
        SubscriptionLink subscription = DriverConductor.removeSubscriptionLink(this.subscriptionLinks, registrationId);
        if (null == subscription) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        subscription.close();
        ReceiveChannelEndpoint channelEndpoint = subscription.channelEndpoint();
        if (null != channelEndpoint) {
            if (subscription.hasSessionId()) {
                if (0L == channelEndpoint.decRefToStreamAndSession(subscription.streamId(), subscription.sessionId())) {
                    this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId(), subscription.sessionId());
                }
            } else if (0 == channelEndpoint.decRefToStream(subscription.streamId())) {
                this.receiverProxy.removeSubscription(channelEndpoint, subscription.streamId());
            }
            if (channelEndpoint.shouldBeClosed()) {
                this.receiverProxy.closeReceiveChannelEndpoint(channelEndpoint);
                channelEndpoint.closeStatusIndicator();
                this.receiveChannelEndpointByChannelMap.remove((Object)channelEndpoint.udpChannel().canonicalForm());
            }
        }
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onClientKeepalive(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.timeOfLastKeepaliveMs(this.cachedEpochClock.time());
        }
    }

    void onAddCounter(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength, long correlationId, long clientId) {
        AeronClient client = this.getOrAddClient(clientId);
        AtomicCounter counter = this.countersManager.newCounter(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
        this.countersManager.setCounterOwnerId(counter.id(), clientId);
        this.countersManager.setCounterRegistrationId(counter.id(), correlationId);
        this.counterLinks.add(new CounterLink(counter, correlationId, client));
        this.clientProxy.onCounterReady(correlationId, counter.id());
    }

    void onRemoveCounter(long registrationId, long correlationId) {
        CounterLink counterLink = null;
        ArrayList<CounterLink> counterLinks = this.counterLinks;
        int size = counterLinks.size();
        for (int i = 0; i < size; ++i) {
            CounterLink link = counterLinks.get(i);
            if (registrationId != link.registrationId()) continue;
            counterLink = link;
            ArrayListUtil.fastUnorderedRemove(counterLinks, (int)i);
            break;
        }
        if (null == counterLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_COUNTER, "unknown counter: " + registrationId);
        }
        this.clientProxy.operationSucceeded(correlationId);
        this.clientProxy.onUnavailableCounter(registrationId, counterLink.counterId());
        counterLink.close();
    }

    void onClientClose(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null != client) {
            client.onClosedByCommand();
        }
    }

    void onAddRcvDestination(long registrationId, String destinationChannel, long correlationId) {
        SubscriptionLink subscriptionLink = null;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink link = this.subscriptionLinks.get(i);
            if (registrationId != link.registrationId()) continue;
            subscriptionLink = link;
            break;
        }
        if (null == subscriptionLink) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        ReceiveChannelEndpoint receiveChannelEndpoint = subscriptionLink.channelEndpoint();
        receiveChannelEndpoint.validateAllowsDestinationControl();
        UdpChannel udpChannel = UdpChannel.parse(destinationChannel, this.nameResolver, true);
        AtomicCounter localSocketAddressIndicator = ReceiveLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, registrationId, receiveChannelEndpoint.statusIndicatorCounterId());
        ReceiveDestinationTransport transport = new ReceiveDestinationTransport(udpChannel, this.ctx, localSocketAddressIndicator);
        this.receiverProxy.addDestination(receiveChannelEndpoint, transport);
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onRemoveRcvDestination(long registrationId, String destinationChannel, long correlationId) {
        ReceiveChannelEndpoint receiveChannelEndpoint = null;
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscriptionLink = this.subscriptionLinks.get(i);
            if (registrationId != subscriptionLink.registrationId()) continue;
            receiveChannelEndpoint = subscriptionLink.channelEndpoint();
            break;
        }
        if (null == receiveChannelEndpoint) {
            throw new ControlProtocolException(ErrorCode.UNKNOWN_SUBSCRIPTION, "unknown subscription: " + registrationId);
        }
        receiveChannelEndpoint.validateAllowsDestinationControl();
        this.receiverProxy.removeDestination(receiveChannelEndpoint, UdpChannel.parse(destinationChannel, this.nameResolver, true));
        this.clientProxy.operationSucceeded(correlationId);
    }

    void onTerminateDriver(DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        if (this.ctx.terminationValidator().allowTermination(this.ctx.aeronDirectory(), tokenBuffer, tokenOffset, tokenLength)) {
            this.ctx.terminationHook().run();
        }
    }

    private void heartbeatAndCheckTimers(long nowNs) {
        long nowMs = this.cachedEpochClock.time();
        this.toDriverCommands.consumerHeartbeatTime(nowMs);
        this.checkManagedResources(this.clients, nowNs, nowMs);
        this.checkManagedResources(this.publicationLinks, nowNs, nowMs);
        this.checkManagedResources(this.networkPublications, nowNs, nowMs);
        this.checkManagedResources(this.subscriptionLinks, nowNs, nowMs);
        this.checkManagedResources(this.publicationImages, nowNs, nowMs);
        this.checkManagedResources(this.ipcPublications, nowNs, nowMs);
        this.checkManagedResources(this.counterLinks, nowNs, nowMs);
    }

    private void checkForBlockedToDriverCommands(long nowNs) {
        long consumerPosition = this.toDriverCommands.consumerPosition();
        if (consumerPosition == this.lastConsumerCommandPosition) {
            if (this.toDriverCommands.producerPosition() > consumerPosition && this.timeOfLastToDriverPositionChangeNs + this.clientLivenessTimeoutNs - nowNs < 0L && this.toDriverCommands.unblock()) {
                this.ctx.systemCounters().get(SystemCounterDescriptor.UNBLOCKED_COMMANDS).incrementOrdered();
            }
        } else {
            this.timeOfLastToDriverPositionChangeNs = nowNs;
            this.lastConsumerCommandPosition = consumerPosition;
        }
    }

    private ArrayList<SubscriberPosition> createSubscriberPositions(int sessionId, int streamId, ReceiveChannelEndpoint channelEndpoint, long joinPosition) {
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (!subscription.matches(channelEndpoint, streamId, sessionId)) continue;
            UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, subscription.aeronClient().clientId(), subscription.registrationId(), sessionId, streamId, subscription.channel(), joinPosition);
            position.setOrdered(joinPosition);
            subscriberPositions.add(new SubscriberPosition(subscription, null, (Position)position));
        }
        return subscriberPositions;
    }

    private static NetworkPublication findPublication(ArrayList<NetworkPublication> publications, int streamId, SendChannelEndpoint channelEndpoint) {
        int size = publications.size();
        for (int i = 0; i < size; ++i) {
            NetworkPublication publication = publications.get(i);
            if (streamId != publication.streamId() || channelEndpoint != publication.channelEndpoint() || NetworkPublication.State.ACTIVE != publication.state() || publication.isExclusive()) continue;
            return publication;
        }
        return null;
    }

    private NetworkPublication newNetworkPublication(long registrationId, long clientId, int streamId, String channel, UdpChannel udpChannel, SendChannelEndpoint channelEndpoint, PublicationParams params, boolean isExclusive) {
        String canonicalForm = udpChannel.canonicalForm();
        int sessionId = params.hasSessionId ? params.sessionId : this.nextAvailableSessionId(streamId, canonicalForm);
        int initialTermId = params.hasPosition ? params.initialTermId : BitUtil.generateRandomisedId();
        FlowControl flowControl = udpChannel.isMulticast() || udpChannel.isMultiDestination() ? this.ctx.multicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId) : this.ctx.unicastFlowControlSupplier().newInstance(udpChannel, streamId, registrationId);
        flowControl.initialize(this.ctx, udpChannel, initialTermId, params.termLength);
        UnsafeBufferPosition publisherPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition publisherLimit = PublisherLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition senderPosition = SenderPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition senderLimit = SenderLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        this.countersManager.setCounterOwnerId(publisherLimit.id(), clientId);
        if (params.hasPosition) {
            int bits = LogBufferDescriptor.positionBitsToShift((int)params.termLength);
            long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)bits, (int)initialTermId);
            publisherPosition.setOrdered(position);
            publisherLimit.setOrdered(position);
            senderPosition.setOrdered(position);
            senderLimit.setOrdered(position);
        }
        RetransmitHandler retransmitHandler = new RetransmitHandler((NanoClock)this.cachedNanoClock, this.ctx.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS), this.ctx.retransmitUnicastDelayGenerator(), this.ctx.retransmitUnicastLingerGenerator());
        NetworkPublication publication = new NetworkPublication(registrationId, this.ctx, params, channelEndpoint, this.newNetworkPublicationLog(sessionId, streamId, initialTermId, registrationId, params), Configuration.producerWindowLength(params.termLength, this.ctx.publicationTermWindowLength()), (Position)publisherPosition, (Position)publisherLimit, (Position)senderPosition, (Position)senderLimit, SenderBpe.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel), sessionId, streamId, initialTermId, flowControl, retransmitHandler, this.networkPublicationThreadLocals, isExclusive);
        channelEndpoint.incRef();
        this.networkPublications.add(publication);
        this.senderProxy.newNetworkPublication(publication);
        this.linkSpies(this.subscriptionLinks, publication);
        this.activeSessionSet.add((Object)new SessionKey(sessionId, streamId, canonicalForm));
        return publication;
    }

    private RawLog newNetworkPublicationLog(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params) {
        RawLog rawLog = this.logFactory.newPublication(registrationId, params.termLength, params.isSparse);
        this.initPublicationMetadata(sessionId, streamId, initialTermId, registrationId, params, rawLog);
        return rawLog;
    }

    private RawLog newIpcPublicationLog(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params) {
        RawLog rawLog = this.logFactory.newPublication(registrationId, params.termLength, params.isSparse);
        this.initPublicationMetadata(sessionId, streamId, initialTermId, registrationId, params, rawLog);
        return rawLog;
    }

    private void initPublicationMetadata(int sessionId, int streamId, int initialTermId, long registrationId, PublicationParams params, RawLog rawLog) {
        UnsafeBuffer logMetaData = rawLog.metaData();
        this.defaultDataHeader.sessionId(sessionId).streamId(streamId).termId(initialTermId);
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)this.defaultDataHeader);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)params.mtuLength);
        LogBufferDescriptor.termLength((UnsafeBuffer)logMetaData, (int)rawLog.termLength());
        LogBufferDescriptor.pageSize((UnsafeBuffer)logMetaData, (int)this.ctx.filePageSize());
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)registrationId);
        LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)logMetaData, (long)Long.MAX_VALUE);
        DriverConductor.initialisePositionCounters(initialTermId, params, logMetaData);
    }

    private static void initialisePositionCounters(int initialTermId, PublicationParams params, UnsafeBuffer logMetaData) {
        if (params.hasPosition) {
            int termId = params.termId;
            int termCount = termId - initialTermId;
            int activeIndex = LogBufferDescriptor.indexByTerm((int)initialTermId, (int)termId);
            LogBufferDescriptor.rawTail((UnsafeBuffer)logMetaData, (int)activeIndex, (long)LogBufferDescriptor.packTail((int)termId, (int)params.termOffset));
            for (int i = 1; i < 3; ++i) {
                int expectedTermId = termId + i - 3;
                activeIndex = LogBufferDescriptor.nextPartitionIndex((int)activeIndex);
                LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)activeIndex, (int)expectedTermId);
            }
            LogBufferDescriptor.activeTermCount((UnsafeBuffer)logMetaData, (int)termCount);
        } else {
            LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)0, (int)initialTermId);
            for (int i = 1; i < 3; ++i) {
                int expectedTermId = initialTermId + i - 3;
                LogBufferDescriptor.initialiseTailWithTermId((UnsafeBuffer)logMetaData, (int)i, (int)expectedTermId);
            }
        }
    }

    private RawLog newPublicationImageLog(int sessionId, int streamId, int initialTermId, int termBufferLength, boolean isSparse, int senderMtuLength, long correlationId) {
        RawLog rawLog = this.logFactory.newImage(correlationId, termBufferLength, isSparse);
        UnsafeBuffer logMetaData = rawLog.metaData();
        this.defaultDataHeader.sessionId(sessionId).streamId(streamId).termId(initialTermId);
        LogBufferDescriptor.storeDefaultFrameHeader((UnsafeBuffer)logMetaData, (DirectBuffer)this.defaultDataHeader);
        LogBufferDescriptor.initialTermId((UnsafeBuffer)logMetaData, (int)initialTermId);
        LogBufferDescriptor.mtuLength((UnsafeBuffer)logMetaData, (int)senderMtuLength);
        LogBufferDescriptor.termLength((UnsafeBuffer)logMetaData, (int)termBufferLength);
        LogBufferDescriptor.pageSize((UnsafeBuffer)logMetaData, (int)this.ctx.filePageSize());
        LogBufferDescriptor.correlationId((UnsafeBuffer)logMetaData, (long)correlationId);
        LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)logMetaData, (long)Long.MAX_VALUE);
        return rawLog;
    }

    private SendChannelEndpoint getOrCreateSendChannelEndpoint(UdpChannel udpChannel, long registrationId) {
        SendChannelEndpoint channelEndpoint = this.findExistingSendChannelEndpoint(udpChannel);
        if (null == channelEndpoint) {
            channelEndpoint = this.ctx.sendChannelEndpointSupplier().newInstance(udpChannel, SendChannelStatus.allocate(this.tempBuffer, this.countersManager, registrationId, udpChannel.originalUriString()), this.ctx);
            AtomicCounter counter = SendLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, registrationId, channelEndpoint.statusIndicatorCounterId());
            channelEndpoint.localSocketAddressIndicator(counter);
            this.sendChannelEndpointByChannelMap.put((Object)udpChannel.canonicalForm(), (Object)channelEndpoint);
            this.senderProxy.registerSendChannelEndpoint(channelEndpoint);
        }
        return channelEndpoint;
    }

    private SendChannelEndpoint findExistingSendChannelEndpoint(UdpChannel udpChannel) {
        if (udpChannel.hasTag()) {
            for (SendChannelEndpoint endpoint : this.sendChannelEndpointByChannelMap.values()) {
                UdpChannel endpointUdpChannel = endpoint.udpChannel();
                if (!endpointUdpChannel.matchesTag(udpChannel)) continue;
                return endpoint;
            }
            if (!(udpChannel.hasExplicitControl() || udpChannel.isManualControlMode() || udpChannel.channelUri().containsKey("endpoint"))) {
                throw new InvalidChannelException("URI must have explicit control, endpoint, or be manual control-mode when original: " + udpChannel.originalUriString());
            }
        }
        return (SendChannelEndpoint)this.sendChannelEndpointByChannelMap.get((Object)udpChannel.canonicalForm());
    }

    private void checkForClashingSubscription(SubscriptionParams params, UdpChannel udpChannel, int streamId) {
        ReceiveChannelEndpoint channelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null != channelEndpoint) {
            int size = this.subscriptionLinks.size();
            for (int i = 0; i < size; ++i) {
                boolean matchesTag;
                SubscriptionLink subscription = this.subscriptionLinks.get(i);
                boolean bl = matchesTag = !udpChannel.hasTag() || channelEndpoint.matchesTag(udpChannel);
                if (!matchesTag || !subscription.matches(channelEndpoint, streamId, params)) continue;
                if (params.isReliable != subscription.isReliable()) {
                    throw new IllegalStateException("option conflicts with existing subscriptions: reliable=" + params.isReliable);
                }
                if (params.isRejoin == subscription.isRejoin()) continue;
                throw new IllegalStateException("option conflicts with existing subscriptions: rejoin=" + params.isRejoin);
            }
        }
    }

    private void linkMatchingImages(SubscriptionLink subscription) {
        long registrationId = subscription.registrationId();
        long clientId = subscription.aeronClient().clientId();
        int streamId = subscription.streamId();
        String channel = subscription.channel();
        int size = this.publicationImages.size();
        for (int i = 0; i < size; ++i) {
            PublicationImage image = this.publicationImages.get(i);
            if (!subscription.matches(image) || !image.isAcceptingSubscriptions()) continue;
            long joinPosition = image.joinPosition();
            int sessionId = image.sessionId();
            UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, clientId, registrationId, sessionId, streamId, channel, joinPosition);
            position.setOrdered(joinPosition);
            subscription.link(image, (ReadablePosition)position);
            image.addSubscriber(subscription, (ReadablePosition)position);
            this.clientProxy.onAvailableImage(image.correlationId(), streamId, sessionId, registrationId, position.id(), image.rawLog().fileName(), Configuration.sourceIdentity(image.sourceAddress()));
        }
    }

    private ArrayList<SubscriberPosition> linkIpcSubscriptions(IpcPublication publication) {
        ArrayList<SubscriberPosition> subscriberPositions = new ArrayList<SubscriberPosition>();
        int size = this.subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = this.subscriptionLinks.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            Position subPos = this.linkIpcSubscription(publication, subscription);
            subscriberPositions.add(new SubscriberPosition(subscription, publication, subPos));
        }
        return subscriberPositions;
    }

    private Position linkIpcSubscription(IpcPublication publication, SubscriptionLink subscription) {
        long joinPosition = publication.joinPosition();
        long registrationId = subscription.registrationId();
        long clientId = subscription.aeronClient().clientId();
        int sessionId = publication.sessionId();
        int streamId = subscription.streamId();
        String channel = subscription.channel();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, clientId, registrationId, sessionId, streamId, channel, joinPosition);
        position.setOrdered(joinPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber(subscription, (ReadablePosition)position);
        return position;
    }

    private Position linkSpy(NetworkPublication publication, SubscriptionLink subscription) {
        long joinPosition = publication.consumerPosition();
        long registrationId = subscription.registrationId();
        long clientId = subscription.aeronClient().clientId();
        int streamId = publication.streamId();
        int sessionId = publication.sessionId();
        String channel = subscription.channel();
        UnsafeBufferPosition position = SubscriberPos.allocate(this.tempBuffer, this.countersManager, clientId, registrationId, sessionId, streamId, channel, joinPosition);
        position.setOrdered(joinPosition);
        subscription.link(publication, (ReadablePosition)position);
        publication.addSubscriber(subscription, (ReadablePosition)position);
        return position;
    }

    private ReceiveChannelEndpoint getOrCreateReceiveChannelEndpoint(UdpChannel udpChannel, long registrationId) {
        ReceiveChannelEndpoint channelEndpoint = this.findExistingReceiveChannelEndpoint(udpChannel);
        if (null == channelEndpoint) {
            String channel = udpChannel.originalUriString();
            channelEndpoint = this.ctx.receiveChannelEndpointSupplier().newInstance(udpChannel, new DataPacketDispatcher(this.ctx.driverConductorProxy(), this.receiverProxy.receiver()), ReceiveChannelStatus.allocate(this.tempBuffer, this.countersManager, registrationId, channel), this.ctx);
            if (!udpChannel.isManualControlMode()) {
                AtomicCounter counter = ReceiveLocalSocketAddress.allocate(this.tempBuffer, this.countersManager, registrationId, channelEndpoint.statusIndicatorCounterId());
                channelEndpoint.localSocketAddressIndicator(counter);
            }
            this.receiveChannelEndpointByChannelMap.put((Object)udpChannel.canonicalForm(), (Object)channelEndpoint);
            this.receiverProxy.registerReceiveChannelEndpoint(channelEndpoint);
        }
        return channelEndpoint;
    }

    private ReceiveChannelEndpoint findExistingReceiveChannelEndpoint(UdpChannel udpChannel) {
        ReceiveChannelEndpoint endpoint;
        if (udpChannel.hasTag()) {
            for (ReceiveChannelEndpoint endpoint2 : this.receiveChannelEndpointByChannelMap.values()) {
                if (!endpoint2.matchesTag(udpChannel)) continue;
                return endpoint2;
            }
        }
        if (null != (endpoint = (ReceiveChannelEndpoint)this.receiveChannelEndpointByChannelMap.get((Object)udpChannel.canonicalForm())) && endpoint.hasTag() && udpChannel.hasTag() && endpoint.tag() != udpChannel.tag()) {
            endpoint = null;
        }
        return endpoint;
    }

    private AeronClient getOrAddClient(long clientId) {
        AeronClient client = DriverConductor.findClient(this.clients, clientId);
        if (null == client) {
            AtomicCounter counter = ClientHeartbeatTimestamp.allocate(this.tempBuffer, this.countersManager, clientId);
            int counterId = counter.id();
            counter.setOrdered(this.cachedEpochClock.time());
            this.countersManager.setCounterOwnerId(counterId, clientId);
            this.countersManager.setCounterRegistrationId(counterId, clientId);
            client = new AeronClient(clientId, this.clientLivenessTimeoutNs, this.ctx.systemCounters().get(SystemCounterDescriptor.CLIENT_TIMEOUTS), counter);
            this.clients.add(client);
            this.clientProxy.onCounterReady(clientId, counterId);
        }
        return client;
    }

    private IpcPublication getOrAddIpcPublication(long correlationId, long clientId, int streamId, String channel, boolean isExclusive) {
        IpcPublication publication = null;
        ChannelUri channelUri = ChannelUri.parse((CharSequence)channel);
        PublicationParams params = PublicationParams.getPublicationParams(channelUri, this.ctx, this, isExclusive, true);
        if (!isExclusive) {
            publication = DriverConductor.findSharedIpcPublication(this.ipcPublications, streamId);
        }
        if (null == publication) {
            if (params.hasSessionId) {
                this.checkForSessionClash(params.sessionId, streamId, "ipc");
            }
            PublicationParams.validateMtuForMaxMessage(params);
            publication = this.addIpcPublication(correlationId, clientId, streamId, channel, isExclusive, params);
        } else {
            PublicationParams.confirmMatch(channelUri, params, publication.rawLog(), publication.sessionId());
        }
        return publication;
    }

    private IpcPublication addIpcPublication(long registrationId, long clientId, int streamId, String channel, boolean isExclusive, PublicationParams params) {
        int sessionId = params.hasSessionId ? params.sessionId : this.nextAvailableSessionId(streamId, "ipc");
        int initialTermId = params.hasPosition ? params.initialTermId : BitUtil.generateRandomisedId();
        RawLog rawLog = this.newIpcPublicationLog(sessionId, streamId, initialTermId, registrationId, params);
        UnsafeBufferPosition publisherPosition = PublisherPos.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        UnsafeBufferPosition publisherLimit = PublisherLimit.allocate(this.tempBuffer, this.countersManager, registrationId, sessionId, streamId, channel);
        this.countersManager.setCounterOwnerId(publisherLimit.id(), clientId);
        if (params.hasPosition) {
            int positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)params.termLength);
            long position = LogBufferDescriptor.computePosition((int)params.termId, (int)params.termOffset, (int)positionBitsToShift, (int)initialTermId);
            publisherPosition.setOrdered(position);
            publisherLimit.setOrdered(position);
        }
        IpcPublication publication = new IpcPublication(registrationId, this.ctx, params.entityTag, sessionId, streamId, (Position)publisherPosition, (Position)publisherLimit, rawLog, Configuration.producerWindowLength(params.termLength, this.ctx.ipcPublicationTermWindowLength()), isExclusive);
        this.ipcPublications.add(publication);
        this.activeSessionSet.add((Object)new SessionKey(sessionId, streamId, "ipc"));
        return publication;
    }

    private static AeronClient findClient(ArrayList<AeronClient> clients, long clientId) {
        AeronClient aeronClient = null;
        int size = clients.size();
        for (int i = 0; i < size; ++i) {
            AeronClient client = clients.get(i);
            if (client.clientId() != clientId) continue;
            aeronClient = client;
            break;
        }
        return aeronClient;
    }

    private static SubscriptionLink removeSubscriptionLink(ArrayList<SubscriptionLink> subscriptionLinks, long registrationId) {
        SubscriptionLink subscriptionLink = null;
        int size = subscriptionLinks.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = subscriptionLinks.get(i);
            if (subscription.registrationId() != registrationId) continue;
            subscriptionLink = subscription;
            ArrayListUtil.fastUnorderedRemove(subscriptionLinks, (int)i);
            break;
        }
        return subscriptionLink;
    }

    private static IpcPublication findSharedIpcPublication(ArrayList<IpcPublication> ipcPublications, long streamId) {
        IpcPublication ipcPublication = null;
        int size = ipcPublications.size();
        for (int i = 0; i < size; ++i) {
            IpcPublication publication = ipcPublications.get(i);
            if ((long)publication.streamId() != streamId || publication.isExclusive() || IpcPublication.State.ACTIVE != publication.state()) continue;
            ipcPublication = publication;
            break;
        }
        return ipcPublication;
    }

    private void checkForSessionClash(int sessionId, int streamId, String channel) {
        if (this.activeSessionSet.contains((Object)new SessionKey(sessionId, streamId, channel))) {
            throw new IllegalStateException("existing publication has clashing session id: " + sessionId);
        }
    }

    private int nextAvailableSessionId(int streamId, String channel) {
        int sessionId;
        SessionKey sessionKey = new SessionKey(streamId, channel);
        do {
            ++this.nextSessionId;
            if (this.ctx.publicationReservedSessionIdLow() <= sessionId && sessionId <= this.ctx.publicationReservedSessionIdHigh()) {
                this.nextSessionId = this.ctx.publicationReservedSessionIdHigh() + 1;
                sessionId = this.nextSessionId++;
            }
            sessionKey.sessionId = sessionId;
        } while (this.activeSessionSet.contains((Object)sessionKey));
        return sessionId;
    }

    private <T extends DriverManagedResource> void checkManagedResources(ArrayList<T> list, long nowNs, long nowMs) {
        int lastIndex;
        for (int i = lastIndex = list.size() - 1; i >= 0; --i) {
            DriverManagedResource resource = (DriverManagedResource)list.get(i);
            resource.onTimeEvent(nowNs, nowMs, this);
            if (!resource.hasReachedEndOfLife()) continue;
            if (resource.free()) {
                ArrayListUtil.fastUnorderedRemove(list, (int)i, (int)lastIndex--);
                CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)resource);
                continue;
            }
            this.ctx.systemCounters().get(SystemCounterDescriptor.FREE_FAILS).incrementOrdered();
        }
    }

    private void linkSpies(ArrayList<SubscriptionLink> links, NetworkPublication publication) {
        int size = links.size();
        for (int i = 0; i < size; ++i) {
            SubscriptionLink subscription = links.get(i);
            if (!subscription.matches(publication) || subscription.isLinked(publication)) continue;
            this.clientProxy.onAvailableImage(publication.registrationId(), publication.streamId(), publication.sessionId(), subscription.registrationId(), this.linkSpy(publication, subscription).id(), publication.rawLog().fileName(), "aeron:ipc");
        }
    }

    private void updateClocks(long nowNs) {
        if (this.clockUpdateDeadlineNs - nowNs < 0L) {
            this.clockUpdateDeadlineNs = nowNs + CLOCK_UPDATE_DURATION_NS;
            this.cachedNanoClock.update(nowNs);
            this.cachedEpochClock.update(this.epochClock.time());
        }
    }

    private int processTimers(long nowNs) {
        int workCount = 0;
        if (this.timeOfLastTimerCheckNs + this.timerIntervalNs - nowNs < 0L) {
            this.heartbeatAndCheckTimers(nowNs);
            this.checkForBlockedToDriverCommands(nowNs);
            this.timeOfLastTimerCheckNs = nowNs;
            workCount = 1;
        }
        return workCount;
    }

    private static boolean isOldestSubscriptionSparse(ArrayList<SubscriberPosition> subscriberPositions) {
        SubscriberPosition subscriberPosition = subscriberPositions.get(0);
        long regId = subscriberPosition.subscription().registrationId();
        boolean isSparse = subscriberPosition.subscription().isSparse();
        int size = subscriberPositions.size();
        for (int i = 1; i < size; ++i) {
            SubscriptionLink subscription = subscriberPositions.get(i).subscription();
            if (subscription.registrationId() >= regId) continue;
            isSparse = subscription.isSparse();
            regId = subscription.registrationId();
        }
        return isSparse;
    }

    private int trackStreamPositions(int existingWorkCount, long nowNs) {
        int workCount = existingWorkCount;
        ArrayList<PublicationImage> publicationImages = this.publicationImages;
        int size = publicationImages.size();
        for (int i = 0; i < size; ++i) {
            workCount += publicationImages.get(i).trackRebuild(nowNs, this.statusMessageTimeoutNs);
        }
        ArrayList<NetworkPublication> networkPublications = this.networkPublications;
        int size2 = networkPublications.size();
        for (int i = 0; i < size2; ++i) {
            workCount += networkPublications.get(i).updatePublisherLimit();
        }
        ArrayList<IpcPublication> ipcPublications = this.ipcPublications;
        int size3 = ipcPublications.size();
        for (int i = 0; i < size3; ++i) {
            workCount += ipcPublications.get(i).updatePublisherLimit();
        }
        return workCount;
    }
}

