/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import java.util.Queue;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.status.AtomicCounter;

public final class DriverConductorProxy {
    private final ThreadingMode threadingMode;
    private final Queue<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private DriverConductor driverConductor;

    DriverConductorProxy(ThreadingMode threadingMode, Queue<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public void channelEndpointError(long statusIndicatorId, Exception error) {
        if (this.notConcurrent()) {
            this.driverConductor.onChannelEndpointError(statusIndicatorId, error);
        } else {
            this.offer(() -> this.driverConductor.onChannelEndpointError(statusIndicatorId, error));
        }
    }

    public void reResolveEndpoint(String endpoint, SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.driverConductor.onReResolveEndpoint(endpoint, channelEndpoint, address);
        } else {
            this.offer(() -> this.driverConductor.onReResolveEndpoint(endpoint, channelEndpoint, address));
        }
    }

    public void reResolveControl(String endpoint, UdpChannel udpChannel, ReceiveChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.driverConductor.onReResolveControl(endpoint, udpChannel, channelEndpoint, address);
        } else {
            this.offer(() -> this.driverConductor.onReResolveControl(endpoint, udpChannel, channelEndpoint, address));
        }
    }

    public boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    void driverConductor(DriverConductor driverConductor) {
        this.driverConductor = driverConductor;
    }

    void createPublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int termOffset, int termLength, int mtuLength, int transportIndex, InetSocketAddress controlAddress, InetSocketAddress srcAddress, ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.driverConductor.onCreatePublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, transportIndex, controlAddress, srcAddress, channelEndpoint);
        } else {
            this.offer(() -> this.driverConductor.onCreatePublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, transportIndex, controlAddress, srcAddress, channelEndpoint));
        }
    }

    private void offer(Runnable cmd) {
        while (!this.commandQueue.offer(cmd)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.interrupted()) continue;
            throw new AgentTerminationException("unexpected interrupt");
        }
    }
}

