/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.net.InetSocketAddress;

class PendingSetupMessageFromSource {
    private final int sessionId;
    private final int streamId;
    private final int transportIndex;
    private final boolean periodic;
    private final ReceiveChannelEndpoint channelEndpoint;
    private InetSocketAddress controlAddress;
    private long timeOfStatusMessageNs;

    PendingSetupMessageFromSource(int sessionId, int streamId, int transportIndex, ReceiveChannelEndpoint channelEndpoint, boolean periodic, InetSocketAddress controlAddress) {
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.transportIndex = transportIndex;
        this.channelEndpoint = channelEndpoint;
        this.periodic = periodic;
        this.controlAddress = controlAddress;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public int transportIndex() {
        return this.transportIndex;
    }

    public ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    public boolean shouldElicitSetupMessage() {
        return this.channelEndpoint.shouldElicitSetupMessage();
    }

    public void controlAddress(InetSocketAddress newControlAddress) {
        this.controlAddress = newControlAddress;
    }

    public InetSocketAddress controlAddress() {
        return this.controlAddress;
    }

    public long timeOfStatusMessageNs() {
        return this.timeOfStatusMessageNs;
    }

    public void timeOfStatusMessageNs(long nowNs) {
        this.timeOfStatusMessageNs = nowNs;
    }

    public void removeFromDataPacketDispatcher() {
        this.channelEndpoint.removePendingSetup(this.sessionId, this.streamId);
    }
}

