/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.agrona.AsciiEncoding;
import org.agrona.Strings;

class InterfaceSearchAddress {
    private static final InterfaceSearchAddress WILDCARD = new InterfaceSearchAddress(new InetSocketAddress(0), 0);
    private final InetSocketAddress address;
    private final int subnetPrefix;

    InterfaceSearchAddress(InetSocketAddress address, int subnetPrefix) {
        this.address = address;
        this.subnetPrefix = subnetPrefix;
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    InetAddress getInetAddress() {
        return this.address.getAddress();
    }

    int getSubnetPrefix() {
        return this.subnetPrefix;
    }

    int getPort() {
        return this.address.getPort();
    }

    static InterfaceSearchAddress wildcard() {
        return WILDCARD;
    }

    static InterfaceSearchAddress parse(String addressAndPort) throws UnknownHostException {
        if (Strings.isEmpty((String)addressAndPort)) {
            throw new IllegalArgumentException("search address string is null or empty");
        }
        int slashIndex = -1;
        int colonIndex = -1;
        int rightAngleBraceIndex = -1;
        int length = addressAndPort.length();
        block5: for (int i = 0; i < length; ++i) {
            switch (addressAndPort.charAt(i)) {
                case '/': {
                    slashIndex = i;
                    continue block5;
                }
                case ':': {
                    colonIndex = i;
                    continue block5;
                }
                case ']': {
                    rightAngleBraceIndex = i;
                }
            }
        }
        String addressString = InterfaceSearchAddress.getAddress(addressAndPort, slashIndex, colonIndex, rightAngleBraceIndex);
        InetAddress hostAddress = InetAddress.getByName(addressString);
        int port = InterfaceSearchAddress.getPort(addressAndPort, slashIndex, colonIndex, rightAngleBraceIndex);
        int defaultSubnetPrefix = hostAddress.getAddress().length * 8;
        int subnetPrefix = InterfaceSearchAddress.getSubnet(addressAndPort, slashIndex, defaultSubnetPrefix);
        return new InterfaceSearchAddress(new InetSocketAddress(hostAddress, port), subnetPrefix);
    }

    private static int getSubnet(String s, int slashIndex, int defaultSubnetPrefix) {
        if (slashIndex < 0) {
            return defaultSubnetPrefix;
        }
        if (s.length() - 1 == slashIndex) {
            throw new IllegalArgumentException("invalid subnet: " + s);
        }
        int subnetStringBegin = slashIndex + 1;
        return AsciiEncoding.parseIntAscii((CharSequence)s, (int)subnetStringBegin, (int)(s.length() - subnetStringBegin));
    }

    private static int getPort(String s, int slashIndex, int colonIndex, int rightAngleBraceIndex) {
        if (colonIndex < 0 || rightAngleBraceIndex > colonIndex) {
            return 0;
        }
        if (s.length() - 1 == colonIndex) {
            throw new IllegalArgumentException("invalid port: " + s);
        }
        int portStringBegin = colonIndex + 1;
        int portStringEnd = slashIndex > 0 ? slashIndex : s.length();
        return AsciiEncoding.parseIntAscii((CharSequence)s, (int)portStringBegin, (int)(portStringEnd - portStringBegin));
    }

    private static String getAddress(String s, int slashIndex, int colonIndex, int rightAngleBraceIndex) {
        int addressEnd = s.length();
        if (slashIndex >= 0) {
            addressEnd = slashIndex;
        }
        if (colonIndex >= 0 && colonIndex > rightAngleBraceIndex) {
            addressEnd = colonIndex;
        }
        return s.substring(0, addressEnd);
    }
}

