/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverNameResolverCache;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpNameResolutionTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.protocol.HeaderFlyweight;
import io.aeron.protocol.ResolutionEntryFlyweight;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class DriverNameResolver
implements AutoCloseable,
UdpNameResolutionTransport.UdpFrameHandler,
NameResolver {
    private static final long SELF_RESOLUTION_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final long NEIGHBOR_RESOLUTION_INTERVAL_MS = TimeUnit.SECONDS.toMillis(2L);
    private static final long TIMEOUT_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final long DUTY_CYCLE_INTERVAL_MS = 10L;
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned((int)65504, (int)64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final HeaderFlyweight headerFlyweight = new HeaderFlyweight(this.unsafeBuffer);
    private final ResolutionEntryFlyweight resolutionEntryFlyweight = new ResolutionEntryFlyweight();
    private final ArrayList<Neighbor> neighborList = new ArrayList();
    private final UdpNameResolutionTransport transport;
    private final DriverNameResolverCache cache;
    private final NameResolver delegateResolver;
    private final AtomicCounter invalidPackets;
    private final AtomicCounter shortSends;
    private final AtomicCounter neighborsCounter;
    private final AtomicCounter cacheEntriesCounter;
    private final byte[] nameTempBuffer = new byte[512];
    private final byte[] addressTempBuffer = new byte[16];
    private final String localDriverName;
    private InetSocketAddress localSocketAddress;
    private final byte[] localName;
    private byte[] localAddress;
    private final String bootstrapNeighbor;
    private InetSocketAddress bootstrapNeighborAddress;
    private long timeOfLastBootstrapNeighborResolveMs;
    private final long neighborTimeoutMs = TIMEOUT_MS;
    private final long selfResolutionIntervalMs = SELF_RESOLUTION_INTERVAL_MS;
    private final long neighborResolutionIntervalMs = NEIGHBOR_RESOLUTION_INTERVAL_MS;
    private final int mtuLength;
    private final boolean preferIPv6 = false;
    private long timeOfLastWorkMs = 0L;
    private long selfResolutionDeadlineMs;
    private long neighborResolutionDeadlineMs;

    DriverNameResolver(MediaDriver.Context ctx) {
        this.mtuLength = ctx.mtuLength();
        this.invalidPackets = ctx.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
        this.shortSends = ctx.systemCounters().get(SystemCounterDescriptor.SHORT_SENDS);
        this.delegateResolver = ctx.nameResolver();
        long nowMs = ctx.epochClock().time();
        this.bootstrapNeighbor = ctx.resolverBootstrapNeighbor();
        this.bootstrapNeighborAddress = null == this.bootstrapNeighbor ? null : UdpNameResolutionTransport.getInetSocketAddress(this.bootstrapNeighbor);
        this.timeOfLastBootstrapNeighborResolveMs = nowMs;
        this.localSocketAddress = null != ctx.resolverInterface() ? UdpNameResolutionTransport.getInterfaceAddress(ctx.resolverInterface()) : new InetSocketAddress("0.0.0.0", 0);
        this.localDriverName = null != ctx.resolverName() ? ctx.resolverName() : DriverNameResolver.getCanonicalName();
        this.localName = this.localDriverName.getBytes(StandardCharsets.US_ASCII);
        this.localAddress = this.localSocketAddress.getAddress().getAddress();
        this.selfResolutionDeadlineMs = 0L;
        this.neighborResolutionDeadlineMs = nowMs + this.neighborResolutionIntervalMs;
        this.cache = new DriverNameResolverCache(TIMEOUT_MS);
        UdpChannel placeholderChannel = UdpChannel.parse("aeron:udp?endpoint=localhost:8050");
        this.transport = new UdpNameResolutionTransport(placeholderChannel, this.localSocketAddress, this.unsafeBuffer, ctx);
        this.neighborsCounter = ctx.countersManager().newCounter("Resolver neighbors", 15);
        this.cacheEntriesCounter = ctx.countersManager().newCounter("Resolver cache entries: name=" + this.localDriverName, 16);
        this.openDatagramChannel();
    }

    @Override
    public void close() {
        CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.transport, this.cache});
    }

    @Override
    public int doWork(long nowMs) {
        int workCount = 0;
        if (this.timeOfLastWorkMs + 10L < nowMs) {
            workCount += this.transport.poll(this, nowMs);
            workCount += this.cache.timeoutOldEntries(nowMs, this.cacheEntriesCounter);
            workCount += this.timeoutNeighbors(nowMs);
            if (nowMs > this.selfResolutionDeadlineMs) {
                this.sendSelfResolutions(nowMs);
            }
            if (nowMs > this.neighborResolutionDeadlineMs) {
                this.sendNeighborResolutions(nowMs);
            }
            this.timeOfLastWorkMs = nowMs;
        }
        return workCount;
    }

    @Override
    public InetAddress resolve(String name, String uriParamName, boolean isReResolution) {
        DriverNameResolverCache.CacheEntry entry = this.cache.lookup(name, (byte)1);
        try {
            if (null == entry) {
                if (name.equals(this.localDriverName)) {
                    return this.localSocketAddress.getAddress();
                }
                return this.delegateResolver.resolve(name, uriParamName, isReResolution);
            }
            return InetAddress.getByAddress(entry.address);
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    @Override
    public String lookup(String name, String uriParamName, boolean isReLookup) {
        return this.delegateResolver.lookup(name, uriParamName, isReLookup);
    }

    @Override
    public int onFrame(UnsafeBuffer unsafeBuffer, int length, InetSocketAddress srcAddress, long nowMs) {
        if (this.headerFlyweight.headerType() == 7) {
            for (int offset = 8; length > offset; offset += this.resolutionEntryFlyweight.entryLength()) {
                this.resolutionEntryFlyweight.wrap((DirectBuffer)unsafeBuffer, offset, length - offset);
                if (length - offset < this.resolutionEntryFlyweight.entryLength()) {
                    this.invalidPackets.increment();
                    return 0;
                }
                this.onResolutionEntry(this.resolutionEntryFlyweight, srcAddress, nowMs);
            }
            return length;
        }
        return 0;
    }

    static String getCanonicalName() {
        String canonicalName = null;
        try {
            canonicalName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return canonicalName;
    }

    private void openDatagramChannel() {
        this.transport.openDatagramChannel(null);
        InetSocketAddress boundAddress = this.transport.boundAddress();
        if (null != boundAddress) {
            this.localSocketAddress = boundAddress;
            this.localAddress = boundAddress.getAddress().getAddress();
            StringBuilder builder = new StringBuilder(": bound ");
            builder.append(this.transport.bindAddressAndPort());
            if (null != this.bootstrapNeighborAddress) {
                builder.append(" bootstrap ").append(this.bootstrapNeighborAddress.getHostString()).append(':').append(this.bootstrapNeighborAddress.getPort());
            }
            this.neighborsCounter.appendToLabel(builder.toString());
        }
    }

    private int timeoutNeighbors(long nowMs) {
        int lastIndex;
        int workCount = 0;
        ArrayList<Neighbor> neighborList = this.neighborList;
        for (int i = lastIndex = neighborList.size() - 1; i >= 0; --i) {
            Neighbor neighbor = neighborList.get(i);
            if (nowMs <= neighbor.timeOfLastActivityMs + this.neighborTimeoutMs) continue;
            Neighbor.neighbourRemoved(nowMs, neighbor.socketAddress);
            ArrayListUtil.fastUnorderedRemove(neighborList, (int)i, (int)lastIndex--);
            ++workCount;
        }
        this.neighborsCounter.setOrdered((long)neighborList.size());
        return workCount;
    }

    private void sendSelfResolutions(long nowMs) {
        this.byteBuffer.clear();
        int currentOffset = 8;
        boolean resType = true;
        this.headerFlyweight.headerType(7).flags((short)0).version((short)0);
        this.resolutionEntryFlyweight.wrap((DirectBuffer)this.unsafeBuffer, 8, this.unsafeBuffer.capacity() - 8);
        this.resolutionEntryFlyweight.resType((byte)1).flags((short)128).udpPort((int)((short)this.localSocketAddress.getPort())).ageInMs(0).putAddress(this.localAddress).putName(this.localName);
        int length = this.resolutionEntryFlyweight.entryLength() + 8;
        this.headerFlyweight.frameLength(length);
        this.byteBuffer.limit(length);
        boolean sendToBootstrap = null != this.bootstrapNeighborAddress;
        int size = this.neighborList.size();
        for (int i = 0; i < size; ++i) {
            Neighbor neighbor = this.neighborList.get(i);
            this.sendResolutionFrameTo(this.byteBuffer, neighbor.socketAddress);
            if (!neighbor.socketAddress.equals(this.bootstrapNeighborAddress)) continue;
            sendToBootstrap = false;
        }
        if (sendToBootstrap) {
            if (nowMs > this.timeOfLastBootstrapNeighborResolveMs + TIMEOUT_MS) {
                this.bootstrapNeighborAddress = UdpNameResolutionTransport.getInetSocketAddress(this.bootstrapNeighbor);
                this.timeOfLastBootstrapNeighborResolveMs = nowMs;
            }
            this.sendResolutionFrameTo(this.byteBuffer, this.bootstrapNeighborAddress);
        }
        this.selfResolutionDeadlineMs = nowMs + this.selfResolutionIntervalMs;
    }

    private void sendResolutionFrameTo(ByteBuffer buffer, InetSocketAddress remoteAddress) {
        buffer.position(0);
        int bytesRemaining = buffer.remaining();
        int bytesSent = this.transport.sendTo(buffer, remoteAddress);
        if (0 <= bytesSent && bytesSent < bytesRemaining) {
            this.shortSends.increment();
        }
    }

    private void onResolutionEntry(ResolutionEntryFlyweight resolutionEntry, InetSocketAddress srcAddress, long nowMs) {
        byte resType = resolutionEntry.resType();
        boolean isSelf = 128 == this.resolutionEntryFlyweight.flags();
        byte[] addr = this.addressTempBuffer;
        int addressLength = this.resolutionEntryFlyweight.getAddress(this.addressTempBuffer);
        if (isSelf && ResolutionEntryFlyweight.isAnyLocalAddress((byte[])this.addressTempBuffer, (int)addressLength)) {
            addr = srcAddress.getAddress().getAddress();
        }
        int nameLength = this.resolutionEntryFlyweight.getName(this.nameTempBuffer);
        long timeOfLastActivity = nowMs - (long)this.resolutionEntryFlyweight.ageInMs();
        int port = this.resolutionEntryFlyweight.udpPort();
        if (port == this.localSocketAddress.getPort() && DriverNameResolverCache.byteSubsetEquals(this.nameTempBuffer, this.localName, nameLength)) {
            return;
        }
        this.cache.addOrUpdateEntry(this.nameTempBuffer, nameLength, timeOfLastActivity, resType, addr, port, this.cacheEntriesCounter);
        int neighborIndex = this.findNeighborByAddress(addr, addressLength, port);
        if (-1 == neighborIndex) {
            byte[] neighborAddress = Arrays.copyOf(addr, addressLength);
            try {
                Neighbor neighbor = new Neighbor(new InetSocketAddress(InetAddress.getByAddress(neighborAddress), port), timeOfLastActivity);
                Neighbor.neighbourAdded(nowMs, neighbor.socketAddress);
                this.neighborList.add(neighbor);
                this.neighborsCounter.setOrdered((long)this.neighborList.size());
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        } else if (isSelf) {
            this.neighborList.get((int)neighborIndex).timeOfLastActivityMs = timeOfLastActivity;
        }
    }

    private int findNeighborByAddress(byte[] address, int addressLength, int port) {
        int size = this.neighborList.size();
        for (int i = 0; i < size; ++i) {
            InetSocketAddress socketAddress = this.neighborList.get((int)i).socketAddress;
            if (!DriverNameResolverCache.byteSubsetEquals(address, socketAddress.getAddress().getAddress(), addressLength) || port != socketAddress.getPort()) continue;
            return i;
        }
        return -1;
    }

    private void sendNeighborResolutions(long nowMs) {
        DriverNameResolverCache.Iterator iter = this.cache.resetIterator();
        while (iter.hasNext()) {
            this.byteBuffer.clear();
            int currentOffset = 8;
            this.headerFlyweight.headerType(7).flags((short)0).version((short)0);
            while (iter.hasNext()) {
                DriverNameResolverCache.CacheEntry entry = iter.next();
                if (currentOffset + ResolutionEntryFlyweight.entryLengthRequired((byte)entry.type, (int)entry.name.length) > this.mtuLength) {
                    iter.rewindNext();
                    break;
                }
                this.resolutionEntryFlyweight.wrap((DirectBuffer)this.unsafeBuffer, currentOffset, this.unsafeBuffer.capacity() - currentOffset);
                this.resolutionEntryFlyweight.resType(entry.type).flags((short)0).udpPort((int)((short)entry.port)).ageInMs((int)(nowMs - entry.timeOfLastActivityMs)).putAddress(entry.address).putName(entry.name);
                int length = this.resolutionEntryFlyweight.entryLength();
                currentOffset += length;
            }
            this.headerFlyweight.frameLength(currentOffset);
            this.byteBuffer.limit(currentOffset);
            int size = this.neighborList.size();
            for (int i = 0; i < size; ++i) {
                Neighbor neighbor = this.neighborList.get(i);
                this.sendResolutionFrameTo(this.byteBuffer, neighbor.socketAddress);
            }
        }
        this.neighborResolutionDeadlineMs = nowMs + this.neighborResolutionIntervalMs;
    }

    static class Neighbor {
        final InetSocketAddress socketAddress;
        long timeOfLastActivityMs;

        Neighbor(InetSocketAddress socketAddress, long nowMs) {
            this.socketAddress = socketAddress;
            this.timeOfLastActivityMs = nowMs;
        }

        static void neighbourAdded(long nowMs, InetSocketAddress address) {
        }

        static void neighbourRemoved(long nowMs, InetSocketAddress address) {
        }
    }
}

