/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PendingSetupMessageFromSource;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.SystemCounterDescriptor;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

public final class Receiver
implements Agent {
    private static final PublicationImage[] EMPTY_IMAGES = new PublicationImage[0];
    private final DataTransportPoller dataTransportPoller;
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue;
    private final AtomicCounter totalBytesReceived;
    private final AtomicCounter resolutionChanges;
    private final CachedNanoClock cachedNanoClock;
    private PublicationImage[] publicationImages = EMPTY_IMAGES;
    private final ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = new ArrayList();
    private final DriverConductorProxy conductorProxy;
    private final long reResolutionCheckIntervalNs;
    private long reResolutionDeadlineNs;

    Receiver(MediaDriver.Context ctx) {
        this.dataTransportPoller = ctx.dataTransportPoller();
        this.commandQueue = ctx.receiverCommandQueue();
        this.totalBytesReceived = ctx.systemCounters().get(SystemCounterDescriptor.BYTES_RECEIVED);
        this.resolutionChanges = ctx.systemCounters().get(SystemCounterDescriptor.RESOLUTION_CHANGES);
        this.cachedNanoClock = ctx.cachedNanoClock();
        this.conductorProxy = ctx.driverConductorProxy();
        this.reResolutionCheckIntervalNs = ctx.reResolutionCheckIntervalNs();
        this.reResolutionDeadlineNs = this.cachedNanoClock.nanoTime() + this.reResolutionCheckIntervalNs;
    }

    public void onClose() {
        this.dataTransportPoller.close();
    }

    public String roleName() {
        return "receiver";
    }

    public int doWork() {
        int lastIndex;
        int workCount = this.commandQueue.drain(Runnable::run, 10);
        int bytesReceived = this.dataTransportPoller.pollTransports();
        this.totalBytesReceived.getAndAddOrdered((long)bytesReceived);
        long nowNs = this.cachedNanoClock.nanoTime();
        PublicationImage[] publicationImages = this.publicationImages;
        for (int i = lastIndex = publicationImages.length - 1; i >= 0; --i) {
            PublicationImage image = publicationImages[i];
            if (image.hasActivityAndNotEndOfStream(nowNs)) {
                workCount += image.sendPendingStatusMessage();
                workCount += image.processPendingLoss();
                workCount += image.initiateAnyRttMeasurements(nowNs);
                continue;
            }
            image.removeFromDispatcher();
            this.publicationImages = 1 == this.publicationImages.length ? EMPTY_IMAGES : (PublicationImage[])ArrayUtil.remove((Object[])this.publicationImages, (int)i);
        }
        this.checkPendingSetupMessages(nowNs);
        if (this.reResolutionCheckIntervalNs > 0L && this.reResolutionDeadlineNs - nowNs < 0L) {
            this.dataTransportPoller.checkForReResolutions(nowNs, this.conductorProxy);
            this.reResolutionDeadlineNs = nowNs + this.reResolutionCheckIntervalNs;
        }
        return workCount + bytesReceived;
    }

    void addPendingSetupMessage(int sessionId, int streamId, int transportIndex, ReceiveChannelEndpoint channelEndpoint, boolean periodic, InetSocketAddress controlAddress) {
        PendingSetupMessageFromSource cmd = new PendingSetupMessageFromSource(sessionId, streamId, transportIndex, channelEndpoint, periodic, controlAddress);
        cmd.timeOfStatusMessageNs(this.cachedNanoClock.nanoTime());
        this.pendingSetupMessages.add(cmd);
    }

    void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.addSubscription(streamId);
    }

    void onAddSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        channelEndpoint.addSubscription(streamId, sessionId);
    }

    void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId) {
        channelEndpoint.removeSubscription(streamId);
    }

    void onRemoveSubscription(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        channelEndpoint.removeSubscription(streamId, sessionId);
    }

    void onNewPublicationImage(ReceiveChannelEndpoint channelEndpoint, PublicationImage image) {
        this.publicationImages = (PublicationImage[])ArrayUtil.add((Object[])this.publicationImages, (Object)image);
        channelEndpoint.addPublicationImage(image);
    }

    void onRegisterReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        if (!channelEndpoint.hasDestinationControl()) {
            channelEndpoint.openChannel(this.conductorProxy);
            channelEndpoint.registerForRead(this.dataTransportPoller);
            channelEndpoint.indicateActive();
            if (channelEndpoint.hasExplicitControl()) {
                this.addPendingSetupMessage(0, 0, 0, channelEndpoint, true, channelEndpoint.explicitControlAddress());
                channelEndpoint.sendSetupElicitingStatusMessage(0, channelEndpoint.explicitControlAddress(), 0, 0);
            }
        } else {
            channelEndpoint.indicateActive();
        }
    }

    void onCloseReceiveChannelEndpoint(ReceiveChannelEndpoint channelEndpoint) {
        int lastIndex;
        ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = this.pendingSetupMessages;
        for (int i = lastIndex = pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = pendingSetupMessages.get(i);
            if (pending.channelEndpoint() != channelEndpoint) continue;
            ArrayListUtil.fastUnorderedRemove(pendingSetupMessages, (int)i, (int)lastIndex--);
            pending.removeFromDataPacketDispatcher();
        }
        channelEndpoint.closeMultiRcvDestination(this.dataTransportPoller);
        channelEndpoint.close();
    }

    void onRemoveCoolDown(ReceiveChannelEndpoint channelEndpoint, int sessionId, int streamId) {
        channelEndpoint.removeCoolDown(sessionId, streamId);
    }

    void onAddDestination(ReceiveChannelEndpoint channelEndpoint, ReceiveDestinationTransport transport) {
        transport.openChannel(this.conductorProxy, channelEndpoint.statusIndicatorCounter());
        int transportIndex = channelEndpoint.addDestination(transport);
        SelectionKey key = this.dataTransportPoller.registerForRead(channelEndpoint, transport, transportIndex);
        transport.selectionKey(key);
        if (transport.hasExplicitControl()) {
            this.addPendingSetupMessage(0, 0, transportIndex, channelEndpoint, true, transport.explicitControlAddress());
            channelEndpoint.sendSetupElicitingStatusMessage(transportIndex, transport.explicitControlAddress(), 0, 0);
        }
        for (PublicationImage image : this.publicationImages) {
            if (channelEndpoint != image.channelEndpoint()) continue;
            image.addDestination(transportIndex, transport);
        }
    }

    void onRemoveDestination(ReceiveChannelEndpoint channelEndpoint, UdpChannel udpChannel) {
        int transportIndex = channelEndpoint.destination(udpChannel);
        if (-1 != transportIndex) {
            ReceiveDestinationTransport transport = channelEndpoint.destination(transportIndex);
            this.dataTransportPoller.cancelRead(channelEndpoint, transport);
            channelEndpoint.removeDestination(transportIndex);
            CloseHelper.close((AutoCloseable)transport);
            this.dataTransportPoller.selectNowWithoutProcessing();
            for (PublicationImage image : this.publicationImages) {
                if (channelEndpoint != image.channelEndpoint()) continue;
                image.removeDestination(transportIndex);
            }
        }
    }

    void onResolutionChange(ReceiveChannelEndpoint channelEndpoint, UdpChannel channel, InetSocketAddress newAddress) {
        int transportIndex = channelEndpoint.hasDestinationControl() ? channelEndpoint.destination(channel) : 0;
        for (PendingSetupMessageFromSource pending : this.pendingSetupMessages) {
            if (pending.channelEndpoint() != channelEndpoint || !pending.isPeriodic() || pending.transportIndex() != transportIndex) continue;
            pending.controlAddress(newAddress);
            this.resolutionChanges.getAndAddOrdered(1L);
        }
        channelEndpoint.updateControlAddress(transportIndex, newAddress);
    }

    private void checkPendingSetupMessages(long nowNs) {
        int lastIndex;
        ArrayList<PendingSetupMessageFromSource> pendingSetupMessages = this.pendingSetupMessages;
        for (int i = lastIndex = pendingSetupMessages.size() - 1; i >= 0; --i) {
            PendingSetupMessageFromSource pending = pendingSetupMessages.get(i);
            if (pending.timeOfStatusMessageNs() + Configuration.PENDING_SETUPS_TIMEOUT_NS - nowNs >= 0L) continue;
            if (!pending.isPeriodic()) {
                ArrayListUtil.fastUnorderedRemove(pendingSetupMessages, (int)i, (int)lastIndex--);
                pending.removeFromDataPacketDispatcher();
                continue;
            }
            if (!pending.shouldElicitSetupMessage()) continue;
            pending.channelEndpoint().sendSetupElicitingStatusMessage(pending.transportIndex(), pending.controlAddress(), pending.sessionId(), pending.streamId());
            pending.timeOfStatusMessageNs(nowNs);
        }
    }
}

