/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CommonContext;
import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionParams;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.util.IdentityHashMap;
import java.util.Map;
import org.agrona.concurrent.status.ReadablePosition;

public abstract class SubscriptionLink
implements DriverManagedResource {
    final long registrationId;
    final int streamId;
    final int sessionId;
    final boolean hasSessionId;
    final boolean isSparse;
    final boolean isTether;
    boolean reachedEndOfLife = false;
    final CommonContext.InferableBoolean group;
    final String channel;
    final AeronClient aeronClient;
    final IdentityHashMap<Subscribable, ReadablePosition> positionBySubscribableMap;

    SubscriptionLink(long registrationId, int streamId, String channel, AeronClient aeronClient, SubscriptionParams params) {
        this.registrationId = registrationId;
        this.streamId = streamId;
        this.channel = channel;
        this.aeronClient = aeronClient;
        this.hasSessionId = params.hasSessionId;
        this.sessionId = params.sessionId;
        this.isSparse = params.isSparse;
        this.isTether = params.isTether;
        this.group = params.group;
        this.positionBySubscribableMap = new IdentityHashMap(this.hasSessionId ? 1 : 8);
    }

    public final String channel() {
        return this.channel;
    }

    public final int streamId() {
        return this.streamId;
    }

    public final long registrationId() {
        return this.registrationId;
    }

    AeronClient aeronClient() {
        return this.aeronClient;
    }

    final int sessionId() {
        return this.sessionId;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return null;
    }

    boolean isReliable() {
        return true;
    }

    boolean isRejoin() {
        return true;
    }

    boolean isTether() {
        return this.isTether;
    }

    boolean isSparse() {
        return this.isSparse;
    }

    CommonContext.InferableBoolean group() {
        return this.group;
    }

    boolean hasSessionId() {
        return this.hasSessionId;
    }

    boolean matches(NetworkPublication publication) {
        return false;
    }

    boolean matches(PublicationImage image) {
        return false;
    }

    boolean matches(IpcPublication publication) {
        return false;
    }

    boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId, SubscriptionParams params) {
        return false;
    }

    boolean matches(ReceiveChannelEndpoint channelEndpoint, int streamId, int sessionId) {
        return false;
    }

    boolean isLinked(Subscribable subscribable) {
        return this.positionBySubscribableMap.containsKey(subscribable);
    }

    void link(Subscribable subscribable, ReadablePosition position) {
        this.positionBySubscribableMap.put(subscribable, position);
    }

    void unlink(Subscribable subscribable) {
        this.positionBySubscribableMap.remove(subscribable);
    }

    boolean isWildcardOrSessionIdMatch(int sessionId) {
        return !this.hasSessionId || this.sessionId == sessionId;
    }

    @Override
    public void close() {
        for (Map.Entry<Subscribable, ReadablePosition> entry : this.positionBySubscribableMap.entrySet()) {
            Subscribable subscribable = entry.getKey();
            ReadablePosition position = entry.getValue();
            subscribable.removeSubscriber(this, position);
        }
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (this.aeronClient.hasTimedOut()) {
            this.reachedEndOfLife = true;
            conductor.cleanupSubscriptionLink(this);
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{registrationId=" + this.registrationId + ", streamId=" + this.streamId + ", sessionId=" + this.sessionId + ", hasSessionId=" + this.hasSessionId + ", isReliable=" + this.isReliable() + ", isSparse=" + this.isSparse() + ", isTether=" + this.isTether() + ", isRejoin=" + this.isRejoin() + ", reachedEndOfLife=" + this.reachedEndOfLife + ", group=" + this.group + ", channel='" + this.channel + '\'' + ", aeronClient=" + this.aeronClient + ", positionBySubscribableMap=" + this.positionBySubscribableMap + '}';
    }
}

