/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.MediaDriver;
import io.aeron.driver.NameResolver;
import io.aeron.driver.media.InterfaceSearchAddress;
import io.aeron.driver.media.SocketAddressParser;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class UdpNameResolutionTransport
extends UdpChannelTransport {
    private final UnsafeBuffer unsafeBuffer;
    private final ByteBuffer byteBuffer;

    public UdpNameResolutionTransport(UdpChannel udpChannel, InetSocketAddress resolverAddress, UnsafeBuffer unsafeBuffer, MediaDriver.Context context) {
        super(udpChannel, null, resolverAddress, null, context);
        this.unsafeBuffer = unsafeBuffer;
        this.byteBuffer = unsafeBuffer.byteBuffer();
    }

    public int poll(UdpFrameHandler handler, long nowMs) {
        int length;
        int bytesReceived = 0;
        InetSocketAddress srcAddress = this.receive(this.byteBuffer);
        if (null != srcAddress && this.isValidFrame(this.unsafeBuffer, length = this.byteBuffer.position())) {
            this.receiveHook(this.unsafeBuffer, length, srcAddress);
            bytesReceived = handler.onFrame(this.unsafeBuffer, length, srcAddress, nowMs);
        }
        return bytesReceived;
    }

    public int sendTo(ByteBuffer buffer, InetSocketAddress remoteAddress) {
        int remaining = buffer.remaining();
        int bytesSent = 0;
        try {
            if (null != this.sendDatagramChannel && this.sendDatagramChannel.isOpen()) {
                this.sendHook(buffer, remoteAddress);
                bytesSent = this.sendDatagramChannel.send(buffer, remoteAddress);
            }
        }
        catch (IOException ex) {
            UdpNameResolutionTransport.sendError(remaining, ex, remoteAddress);
        }
        return bytesSent;
    }

    public InetSocketAddress boundAddress() {
        try {
            return (InetSocketAddress)this.receiveDatagramChannel.getLocalAddress();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static InetSocketAddress getInterfaceAddress(String addressAndPort) {
        try {
            return InterfaceSearchAddress.parse(addressAndPort).getAddress();
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
            return null;
        }
    }

    public static InetSocketAddress getInetSocketAddress(String hostAndPort, NameResolver nameResolver) {
        InetSocketAddress address = null;
        try {
            address = SocketAddressParser.parse(hostAndPort, "endpoint", false, nameResolver);
            if (address.isUnresolved()) {
                throw new UnknownHostException("unresolved - endpoint=" + hostAndPort + ", name-resolver=" + nameResolver.getClass().getName());
            }
        }
        catch (UnknownHostException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return address;
    }

    @FunctionalInterface
    public static interface UdpFrameHandler {
        public int onFrame(UnsafeBuffer var1, int var2, InetSocketAddress var3, long var4);
    }
}

