/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.nio.ByteBuffer;
import org.agrona.BufferUtil;

final class NetworkPublicationThreadLocals {
    private final ByteBuffer heartbeatBuffer;
    private final DataHeaderFlyweight dataHeader;
    private final ByteBuffer setupBuffer;
    private final SetupFlyweight setupHeader;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementHeader;

    NetworkPublicationThreadLocals() {
        ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned((int)192, (int)64);
        byteBuffer.limit(32);
        this.heartbeatBuffer = byteBuffer.slice();
        this.dataHeader = new DataHeaderFlyweight(this.heartbeatBuffer);
        int position = 64;
        byteBuffer.limit(position + 40).position(position);
        this.setupBuffer = byteBuffer.slice();
        this.setupHeader = new SetupFlyweight(this.setupBuffer);
        byteBuffer.limit((position += 64) + 40).position(position);
        this.rttMeasurementBuffer = byteBuffer.slice();
        this.rttMeasurementHeader = new RttMeasurementFlyweight(this.rttMeasurementBuffer);
        this.dataHeader.version((short)0).flags((short)-64).headerType(1).frameLength(0);
        this.setupHeader.version((short)0).headerType(5).frameLength(40);
        this.rttMeasurementHeader.version((short)0).headerType(6).frameLength(40);
    }

    ByteBuffer heartbeatBuffer() {
        return this.heartbeatBuffer;
    }

    DataHeaderFlyweight heartbeatDataHeader() {
        return this.dataHeader;
    }

    ByteBuffer setupBuffer() {
        return this.setupBuffer;
    }

    SetupFlyweight setupHeader() {
        return this.setupHeader;
    }

    ByteBuffer rttMeasurementBuffer() {
        return this.rttMeasurementBuffer;
    }

    RttMeasurementFlyweight rttMeasurementHeader() {
        return this.rttMeasurementHeader;
    }
}

