/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CounterProvider;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.driver.NameResolver;
import java.net.InetAddress;
import java.util.Objects;
import org.agrona.CloseHelper;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.CountersReader;

final class TimeTrackingNameResolver
implements NameResolver,
AutoCloseable {
    private final NameResolver delegateResolver;
    private final NanoClock clock;
    private final DutyCycleTracker maxTimeTracker;

    TimeTrackingNameResolver(NameResolver delegateResolver, NanoClock clock, DutyCycleTracker maxTimeTracker) {
        this.delegateResolver = Objects.requireNonNull(delegateResolver);
        this.clock = Objects.requireNonNull(clock);
        this.maxTimeTracker = Objects.requireNonNull(maxTimeTracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress resolve(String name, String uriParamName, boolean isReResolution) {
        long beginNs = this.clock.nanoTime();
        this.maxTimeTracker.update(beginNs);
        InetAddress address = null;
        try {
            InetAddress inetAddress = address = this.delegateResolver.resolve(name, uriParamName, isReResolution);
            return inetAddress;
        }
        finally {
            long endNs = this.clock.nanoTime();
            this.maxTimeTracker.measureAndUpdate(endNs);
            TimeTrackingNameResolver.logResolve(this.delegateResolver.getClass().getSimpleName(), endNs - beginNs, name, isReResolution, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lookup(String name, String uriParamName, boolean isReLookup) {
        long beginNs = this.clock.nanoTime();
        this.maxTimeTracker.update(beginNs);
        String resolvedName = null;
        try {
            String string = resolvedName = this.delegateResolver.lookup(name, uriParamName, isReLookup);
            return string;
        }
        finally {
            long endNs = this.clock.nanoTime();
            this.maxTimeTracker.measureAndUpdate(endNs);
            TimeTrackingNameResolver.logLookup(this.delegateResolver.getClass().getSimpleName(), endNs - beginNs, name, isReLookup, resolvedName);
        }
    }

    @Override
    public void init(CountersReader countersReader, CounterProvider counterProvider) {
        this.delegateResolver.init(countersReader, counterProvider);
    }

    @Override
    public int doWork(long nowMs) {
        return this.delegateResolver.doWork(nowMs);
    }

    @Override
    public void close() {
        if (this.delegateResolver instanceof AutoCloseable) {
            CloseHelper.close((AutoCloseable)((AutoCloseable)((Object)this.delegateResolver)));
        }
    }

    private static void logResolve(String resolverName, long durationNs, String name, boolean isReResolution, InetAddress resolvedAddress) {
    }

    private static void logLookup(String resolverName, long durationNs, String name, boolean isReLookup, String resolvedName) {
    }
}

