/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;

public final class ReceiveChannelEndpointThreadLocals {
    private final ByteBuffer smBuffer;
    private final StatusMessageFlyweight statusMessageFlyweight;
    private final ByteBuffer nakBuffer;
    private final NakFlyweight nakFlyweight;
    private final ByteBuffer rttMeasurementBuffer;
    private final RttMeasurementFlyweight rttMeasurementFlyweight;
    private long nextReceiverId;

    public ReceiveChannelEndpointThreadLocals() {
        int smLength = 44;
        int bufferLength = BitUtil.align((int)44, (int)64) + BitUtil.align((int)28, (int)64) + BitUtil.align((int)40, (int)64);
        UUID uuid = UUID.randomUUID();
        this.nextReceiverId = uuid.getMostSignificantBits() ^ uuid.getLeastSignificantBits();
        ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned((int)bufferLength, (int)64);
        byteBuffer.limit(44);
        this.smBuffer = byteBuffer.slice();
        this.statusMessageFlyweight = new StatusMessageFlyweight(this.smBuffer);
        int nakMessageOffset = BitUtil.align((int)44, (int)32);
        byteBuffer.limit(nakMessageOffset + 28).position(nakMessageOffset);
        this.nakBuffer = byteBuffer.slice();
        this.nakFlyweight = new NakFlyweight(this.nakBuffer);
        int rttMeasurementOffset = nakMessageOffset + BitUtil.align((int)28, (int)32);
        byteBuffer.limit(rttMeasurementOffset + 40).position(rttMeasurementOffset);
        this.rttMeasurementBuffer = byteBuffer.slice();
        this.rttMeasurementFlyweight = new RttMeasurementFlyweight(this.rttMeasurementBuffer);
        this.statusMessageFlyweight.version((short)0).headerType(3).frameLength(36);
        this.nakFlyweight.version((short)0).headerType(2).frameLength(28);
        this.rttMeasurementFlyweight.version((short)0).headerType(6).frameLength(40);
    }

    public ByteBuffer statusMessageBuffer() {
        return this.smBuffer;
    }

    public StatusMessageFlyweight statusMessageFlyweight() {
        return this.statusMessageFlyweight;
    }

    public ByteBuffer nakBuffer() {
        return this.nakBuffer;
    }

    public NakFlyweight nakFlyweight() {
        return this.nakFlyweight;
    }

    public ByteBuffer rttMeasurementBuffer() {
        return this.rttMeasurementBuffer;
    }

    public RttMeasurementFlyweight rttMeasurementFlyweight() {
        return this.rttMeasurementFlyweight;
    }

    public long nextReceiverId() {
        return this.nextReceiverId++;
    }

    public String toString() {
        return "ReceiveChannelEndpointThreadLocals{nextReceiverId=" + this.nextReceiverId + '}';
    }
}

