/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FlowControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import org.agrona.concurrent.status.CountersManager;

public class MaxMulticastFlowControl
implements FlowControl {
    public static final String FC_PARAM_VALUE = "max";
    public static final MaxMulticastFlowControl INSTANCE = new MaxMulticastFlowControl();
    private static final int RETRANSMIT_RECEIVER_WINDOW_MULTIPLE = 4;

    @Override
    public void initialize(MediaDriver.Context context, CountersManager countersManager, UdpChannel udpChannel, int streamId, int sessionId, long registrationId, int initialTermId, int termBufferLength) {
    }

    @Override
    public void close() {
    }

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        long position = LogBufferDescriptor.computePosition((int)flyweight.consumptionTermId(), (int)flyweight.consumptionTermOffset(), (int)positionBitsToShift, (int)initialTermId);
        return Math.max(senderLimit, position + (long)flyweight.receiverWindowLength());
    }

    @Override
    public void onTriggerSendSetup(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long timeNs) {
    }

    @Override
    public long onSetup(SetupFlyweight flyweight, long senderLimit, long senderPosition, int positionBitsToShift, long timeNs) {
        return senderLimit;
    }

    @Override
    public long onIdle(long timeNs, long senderLimit, long senderPosition, boolean isEos) {
        return senderLimit;
    }

    @Override
    public boolean hasRequiredReceivers() {
        return true;
    }

    @Override
    public int maxRetransmissionLength(int termOffset, int resendLength, int termBufferLength, int mtuLength) {
        return FlowControl.calculateRetransmissionLength(resendLength, termBufferLength, termOffset, 4);
    }
}

