/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ext.CubicCongestionControlConfiguration;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.status.PerImageIndicator;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public class CubicCongestionControl
implements CongestionControl {
    public static final String CC_PARAM_VALUE = "cubic";
    private static final long SECOND_IN_NS = TimeUnit.SECONDS.toNanos(1L);
    private static final int INITCWND = 10;
    private static final int RTT_TIMEOUT_MULTIPLE = 4;
    private static final double C = 0.4;
    private static final double B = 0.2;
    private final int mtu;
    private final int maxCwnd;
    private final int initialWindowLength;
    private final int maxWindowLength;
    private double k;
    private int w_max;
    private int windowLength;
    private int cwnd;
    private long lastUpdateTimestampNs;
    private long lastLossTimestampNs;
    private long lastRttTimestampNs = 0L;
    private long rttNs;
    private long rttTimeoutNs;
    private final long windowUpdateTimeoutNs;
    private final ErrorHandler errorHandler;
    private final AtomicCounter rttIndicator;
    private final AtomicCounter windowIndicator;

    public CubicCongestionControl(long registrationId, UdpChannel udpChannel, int streamId, int sessionId, int termLength, int senderMtuLength, InetSocketAddress controlAddress, InetSocketAddress sourceAddress, NanoClock nanoClock, MediaDriver.Context context, CountersManager countersManager) {
        try {
            this.errorHandler = context.errorHandler();
            this.mtu = senderMtuLength;
            int receiverWindowLength = 0 != udpChannel.receiverWindowLength() ? udpChannel.receiverWindowLength() : context.initialWindowLength();
            this.maxWindowLength = Configuration.receiverWindowLength(termLength, receiverWindowLength);
            this.maxCwnd = this.maxWindowLength / this.mtu;
            this.cwnd = Math.min(10, this.maxCwnd);
            this.initialWindowLength = this.cwnd * this.mtu;
            this.w_max = this.maxCwnd;
            this.k = StrictMath.cbrt((double)this.w_max * 0.2 / 0.4);
            this.windowUpdateTimeoutNs = this.rttNs = CubicCongestionControlConfiguration.INITIAL_RTT_NS;
            this.rttTimeoutNs = this.rttNs * 4L;
            this.rttIndicator = PerImageIndicator.allocate(context.tempBuffer(), "rcv-cc-cubic-rtt", countersManager, registrationId, sessionId, streamId, udpChannel.originalUriString());
            this.windowIndicator = PerImageIndicator.allocate(context.tempBuffer(), "rcv-cc-cubic-wnd", countersManager, registrationId, sessionId, streamId, udpChannel.originalUriString());
            this.windowLength = this.initialWindowLength;
            this.rttIndicator.setOrdered(0L);
            this.windowIndicator.setOrdered((long)this.initialWindowLength);
            this.lastUpdateTimestampNs = this.lastLossTimestampNs = nanoClock.nanoTime();
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.rttIndicator);
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.windowIndicator);
    }

    @Override
    public boolean shouldMeasureRtt(long nowNs) {
        return CubicCongestionControlConfiguration.MEASURE_RTT && this.lastRttTimestampNs + this.rttTimeoutNs - nowNs < 0L;
    }

    @Override
    public void onRttMeasurementSent(long nowNs) {
        this.lastRttTimestampNs = nowNs;
    }

    @Override
    public void onRttMeasurement(long nowNs, long rttNs, InetSocketAddress srcAddress) {
        this.lastRttTimestampNs = nowNs;
        this.rttNs = rttNs;
        this.rttIndicator.setOrdered(rttNs);
        this.rttTimeoutNs = Math.max(rttNs, CubicCongestionControlConfiguration.INITIAL_RTT_NS) * 4L;
    }

    @Override
    public long onTrackRebuild(long nowNs, long newConsumptionPosition, long lastSmPosition, long hwmPosition, long startingRebuildPosition, long endingRebuildPosition, boolean lossOccurred) {
        boolean forceStatusMessage = false;
        if (lossOccurred) {
            forceStatusMessage = true;
            this.w_max = this.cwnd;
            this.k = StrictMath.cbrt((double)this.w_max * 0.2 / 0.4);
            this.cwnd = Math.max(1, (int)((double)this.cwnd * 0.8));
            this.windowLength = this.cwnd * this.mtu;
            this.windowIndicator.setOrdered((long)this.windowLength);
            this.lastLossTimestampNs = nowNs;
        } else if (this.cwnd < this.maxCwnd && this.lastUpdateTimestampNs + this.windowUpdateTimeoutNs - nowNs < 0L) {
            int windowLength;
            double durationSinceDecr = (double)(nowNs - this.lastLossTimestampNs) / (double)SECOND_IN_NS;
            double diffToK = durationSinceDecr - this.k;
            double incr = 0.4 * diffToK * diffToK * diffToK;
            this.cwnd = Math.min(this.maxCwnd, this.w_max + (int)incr);
            if (CubicCongestionControlConfiguration.TCP_MODE && this.cwnd < this.w_max) {
                double rttInSeconds = (double)this.rttNs / (double)SECOND_IN_NS;
                double wTcp = (double)this.w_max * 0.8 + 0.33333333333333337 * (durationSinceDecr / rttInSeconds);
                this.cwnd = Math.max(this.cwnd, (int)wTcp);
            }
            if ((windowLength = this.cwnd * this.mtu) != this.windowLength) {
                this.windowLength = windowLength;
                this.windowIndicator.setOrdered((long)windowLength);
            }
            this.lastUpdateTimestampNs = nowNs;
        } else if (1 == this.cwnd && newConsumptionPosition > lastSmPosition) {
            forceStatusMessage = true;
        }
        return CongestionControl.packOutcome(this.windowLength, forceStatusMessage);
    }

    @Override
    public int initialWindowLength() {
        return this.initialWindowLength;
    }

    @Override
    public int maxWindowLength() {
        return this.maxWindowLength;
    }

    int maxCongestionWindow() {
        return this.maxCwnd;
    }
}

