/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.ChannelUri;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.Destination;
import io.aeron.driver.media.MultiSndDestination;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;

class ManualSndMultiDestination
extends MultiSndDestination {
    ManualSndMultiDestination(CachedNanoClock nanoClock) {
        super(nanoClock);
    }

    @Override
    void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress address) {
        long receiverId = msg.receiverId();
        long nowNs = this.nanoClock.nanoTime();
        for (Destination destination : this.destinations) {
            if (destination.isReceiverIdValid && receiverId == destination.receiverId && address.getPort() == destination.port) {
                destination.timeOfLastActivityNs = nowNs;
                break;
            }
            if (destination.isReceiverIdValid || address.getPort() != destination.port || !address.getAddress().equals(destination.address.getAddress())) continue;
            destination.timeOfLastActivityNs = nowNs;
            destination.receiverId = receiverId;
            destination.isReceiverIdValid = true;
            break;
        }
    }

    @Override
    int send(DatagramChannel channel, ByteBuffer buffer, SendChannelEndpoint channelEndpoint, int bytesToSend) {
        int bytesSent;
        Destination destination;
        int i;
        int startingIndex;
        int position = buffer.position();
        int length = this.destinations.length;
        if ((startingIndex = this.roundRobinIndex++) >= length) {
            startingIndex = 0;
            this.roundRobinIndex = 0;
        }
        for (i = startingIndex; i < length; ++i) {
            destination = this.destinations[i];
            bytesSent = ManualSndMultiDestination.send(channel, buffer, channelEndpoint, bytesToSend, position, destination.address);
            if (bytesSent >= bytesToSend) continue;
            this.roundRobinIndex = i;
            return bytesSent;
        }
        for (i = 0; i < startingIndex; ++i) {
            destination = this.destinations[i];
            bytesSent = ManualSndMultiDestination.send(channel, buffer, channelEndpoint, bytesToSend, position, destination.address);
            if (bytesSent >= bytesToSend) continue;
            this.roundRobinIndex = i;
            return bytesSent;
        }
        return bytesToSend;
    }

    @Override
    void addDestination(ChannelUri channelUri, InetSocketAddress address) {
        this.destinations = (Destination[])ArrayUtil.add((Object[])this.destinations, (Object)new Destination(this.nanoClock.nanoTime(), channelUri.get("endpoint"), address));
        this.destinationsCounter.setOrdered((long)this.destinations.length);
    }

    @Override
    void removeDestination(ChannelUri channelUri, InetSocketAddress address) {
        boolean found = false;
        int index = 0;
        for (Destination destination : this.destinations) {
            if (destination.address.equals(address)) {
                found = true;
                break;
            }
            ++index;
        }
        if (found) {
            this.destinations = 1 == this.destinations.length ? EMPTY_DESTINATIONS : (Destination[])ArrayUtil.remove((Object[])this.destinations, (int)index);
        }
        this.destinationsCounter.setOrdered((long)this.destinations.length);
    }

    @Override
    void checkForReResolution(SendChannelEndpoint channelEndpoint, long nowNs, DriverConductorProxy conductorProxy) {
        for (Destination destination : this.destinations) {
            if (destination.timeOfLastActivityNs + SendChannelEndpoint.DESTINATION_TIMEOUT - nowNs >= 0L) continue;
            destination.timeOfLastActivityNs = nowNs;
            conductorProxy.reResolveEndpoint(destination.endpoint, channelEndpoint, destination.address);
        }
    }

    @Override
    void updateDestination(String endpoint, InetSocketAddress newAddress) {
        for (Destination destination : this.destinations) {
            if (!endpoint.equals(destination.endpoint)) continue;
            destination.address = newAddress;
            destination.port = newAddress.getPort();
        }
    }
}

