/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.protocol.ResolutionEntryFlyweight;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.status.AtomicCounter;

final class DriverNameResolverCache
implements AutoCloseable {
    private static final int INVALID_INDEX = -1;
    private final ArrayList<CacheEntry> entries = new ArrayList();
    private final long timeoutMs;
    private final Iterator iterator = new Iterator();

    DriverNameResolverCache(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    @Override
    public void close() {
    }

    CacheEntry lookup(String name, byte type) {
        int index = this.findEntryIndexByNameAndType(name, type);
        return -1 == index ? null : this.entries.get(index);
    }

    void addOrUpdateEntry(byte[] name, int nameLength, long nowMs, byte type, byte[] address, int port, AtomicCounter cacheEntriesCounter) {
        int existingEntryIndex = this.findEntryIndexByNameAndType(name, nameLength, type);
        int addressLength = ResolutionEntryFlyweight.addressLength((byte)type);
        if (-1 == existingEntryIndex) {
            CacheEntry entry = new CacheEntry(Arrays.copyOf(name, nameLength), type, nowMs, nowMs + this.timeoutMs, Arrays.copyOf(address, addressLength), port);
            this.entries.add(entry);
            cacheEntriesCounter.setOrdered((long)this.entries.size());
        } else {
            CacheEntry entry = this.entries.get(existingEntryIndex);
            entry.timeOfLastActivityMs = nowMs;
            entry.deadlineMs = nowMs + this.timeoutMs;
            if (port != entry.port || !DriverNameResolverCache.byteSubsetEquals(address, entry.address, addressLength)) {
                entry.address = Arrays.copyOf(address, addressLength);
                entry.port = port;
            }
        }
    }

    int timeoutOldEntries(long nowMs, AtomicCounter cacheEntriesCounter) {
        int lastIndex;
        int workCount = 0;
        ArrayList<CacheEntry> listOfEntries = this.entries;
        for (int i = lastIndex = listOfEntries.size() - 1; i >= 0; --i) {
            CacheEntry entry = listOfEntries.get(i);
            if (entry.deadlineMs - nowMs >= 0L) continue;
            ArrayListUtil.fastUnorderedRemove(listOfEntries, (int)i, (int)lastIndex--);
            cacheEntriesCounter.setOrdered((long)listOfEntries.size());
            ++workCount;
        }
        return workCount;
    }

    Iterator resetIterator() {
        this.iterator.cache = this;
        this.iterator.index = -1;
        return this.iterator;
    }

    static boolean byteSubsetEquals(byte[] lhs, byte[] rhs, int length) {
        if (lhs.length < length || rhs.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    static boolean byteSubsetEquals(byte[] lhs, String rhs) {
        int length = rhs.length();
        if (lhs.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (lhs[i] == rhs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private int findEntryIndexByNameAndType(byte[] name, int nameLength, byte type) {
        for (int i = 0; i < this.entries.size(); ++i) {
            CacheEntry entry = this.entries.get(i);
            if (type != entry.type || !DriverNameResolverCache.byteSubsetEquals(entry.name, name, nameLength)) continue;
            return i;
        }
        return -1;
    }

    private int findEntryIndexByNameAndType(String name, byte type) {
        for (int i = 0; i < this.entries.size(); ++i) {
            CacheEntry entry = this.entries.get(i);
            if (type != entry.type || !DriverNameResolverCache.byteSubsetEquals(entry.name, name)) continue;
            return i;
        }
        return -1;
    }

    static final class Iterator {
        int index = -1;
        DriverNameResolverCache cache;

        Iterator() {
        }

        boolean hasNext() {
            return this.index + 1 < this.cache.entries.size();
        }

        CacheEntry next() {
            return this.cache.entries.get(++this.index);
        }

        void rewindNext() {
            --this.index;
        }
    }

    static final class CacheEntry {
        long deadlineMs;
        long timeOfLastActivityMs;
        int port;
        final byte type;
        final byte[] name;
        byte[] address;

        CacheEntry(byte[] name, byte type, long timeOfLastActivityMs, long deadlineMs, byte[] address, int port) {
            this.name = name;
            this.type = type;
            this.timeOfLastActivityMs = timeOfLastActivityMs;
            this.deadlineMs = deadlineMs;
            this.address = address;
            this.port = port;
        }
    }
}

