/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import io.aeron.protocol.ErrorFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;
import org.agrona.concurrent.status.CountersManager;

public interface FlowControl
extends AutoCloseable {
    public static int calculateRetransmissionLength(int resendLength, int termBufferLength, int termOffset, int retransmitReceiverWindowMultiple) {
        int lengthToEndOfTerm = termBufferLength - termOffset;
        int estimatedRetransmitLength = Configuration.receiverWindowLength(termBufferLength, 131072) * retransmitReceiverWindowMultiple;
        return lengthToEndOfTerm < estimatedRetransmitLength ? Math.min(lengthToEndOfTerm, resendLength) : Math.min(estimatedRetransmitLength, resendLength);
    }

    public long onStatusMessage(StatusMessageFlyweight var1, InetSocketAddress var2, long var3, int var5, int var6, long var7);

    public void onTriggerSendSetup(StatusMessageFlyweight var1, InetSocketAddress var2, long var3);

    public long onSetup(SetupFlyweight var1, long var2, long var4, int var6, long var7);

    public void onError(ErrorFlyweight var1, InetSocketAddress var2, long var3);

    public void initialize(MediaDriver.Context var1, CountersManager var2, UdpChannel var3, int var4, int var5, long var6, int var8, int var9);

    public long onIdle(long var1, long var3, long var5, boolean var7);

    public boolean hasRequiredReceivers();

    public int maxRetransmissionLength(int var1, int var2, int var3, int var4);

    @Override
    public void close();
}

