/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PublicationParams;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.LogBufferUnblocker;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class IpcPublication
implements DriverManagedResource,
Subscribable {
    private static final ReadablePosition[] EMPTY_POSITIONS = new ReadablePosition[0];
    private static final InetSocketAddress IPC_SRC_ADDRESS = new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
    private final long registrationId;
    private final long tag;
    private final long unblockTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final long imageLivenessTimeoutNs;
    private final String channel;
    private final int sessionId;
    private final int streamId;
    private final int startingTermId;
    private final int startingTermOffset;
    private final int positionBitsToShift;
    private final int termBufferLength;
    private final int mtuLength;
    private final int termWindowLength;
    private final int initialTermId;
    private final int tripGain;
    private long tripLimit;
    private long consumerPosition;
    private long lastConsumerPosition;
    private long timeOfLastConsumerPositionUpdateNs;
    private long cleanPosition;
    private int refCount = 0;
    private boolean reachedEndOfLife = false;
    private boolean inCoolDown = false;
    private long coolDownExpireTimeNs = 0L;
    private final boolean isExclusive;
    private State state = State.ACTIVE;
    private final UnsafeBuffer[] termBuffers;
    private final Position publisherPos;
    private final Position publisherLimit;
    private final UnsafeBuffer metaDataBuffer;
    private ReadablePosition[] subscriberPositions = EMPTY_POSITIONS;
    private final ArrayList<UntetheredSubscription> untetheredSubscriptions = new ArrayList();
    private final RawLog rawLog;
    private final AtomicCounter unblockedPublications;
    private final AtomicCounter publicationsRevoked;
    private final ErrorHandler errorHandler;

    IpcPublication(long registrationId, String channel, MediaDriver.Context ctx, long tag, int sessionId, int streamId, Position publisherPos, Position publisherLimit, RawLog rawLog, boolean isExclusive, PublicationParams params) {
        int termLength;
        this.registrationId = registrationId;
        this.channel = channel;
        this.tag = tag;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.isExclusive = isExclusive;
        this.termBuffers = rawLog.termBuffers();
        this.initialTermId = LogBufferDescriptor.initialTermId((UnsafeBuffer)rawLog.metaData());
        this.startingTermId = params.termId;
        this.startingTermOffset = params.termOffset;
        this.errorHandler = ctx.errorHandler();
        this.termBufferLength = termLength = params.termLength;
        this.mtuLength = params.mtuLength;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)termLength);
        this.termWindowLength = params.publicationWindowLength;
        this.tripGain = this.termWindowLength >> 3;
        this.publisherPos = publisherPos;
        this.publisherLimit = publisherLimit;
        this.rawLog = rawLog;
        this.unblockTimeoutNs = ctx.publicationUnblockTimeoutNs();
        this.untetheredWindowLimitTimeoutNs = params.untetheredWindowLimitTimeoutNs;
        this.untetheredRestingTimeoutNs = params.untetheredRestingTimeoutNs;
        this.imageLivenessTimeoutNs = ctx.imageLivenessTimeoutNs();
        SystemCounters systemCounters = ctx.systemCounters();
        this.unblockedPublications = systemCounters.get(SystemCounterDescriptor.UNBLOCKED_PUBLICATIONS);
        this.publicationsRevoked = systemCounters.get(SystemCounterDescriptor.PUBLICATIONS_REVOKED);
        this.metaDataBuffer = rawLog.metaData();
        this.lastConsumerPosition = this.consumerPosition = this.producerPosition();
        this.cleanPosition = this.consumerPosition;
        this.timeOfLastConsumerPositionUpdateNs = ctx.cachedNanoClock().nanoTime();
    }

    public String channel() {
        return this.channel;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    @Override
    public long subscribableRegistrationId() {
        return this.registrationId;
    }

    long registrationId() {
        return this.registrationId;
    }

    long tag() {
        return this.tag;
    }

    boolean isExclusive() {
        return this.isExclusive;
    }

    int initialTermId() {
        return this.initialTermId;
    }

    int startingTermId() {
        return this.startingTermId;
    }

    int startingTermOffset() {
        return this.startingTermOffset;
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    int publisherLimitId() {
        return this.publisherLimit.id();
    }

    int termBufferLength() {
        return this.termBufferLength;
    }

    int mtuLength() {
        return this.mtuLength;
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.publisherPos);
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.publisherLimit);
        CloseHelper.closeAll((ErrorHandler)this.errorHandler, (AutoCloseable[])this.subscriberPositions);
        int size = this.untetheredSubscriptions.size();
        for (int i = 0; i < size; ++i) {
            UntetheredSubscription untetheredSubscription = this.untetheredSubscriptions.get(i);
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state) continue;
            CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)untetheredSubscription.position);
        }
    }

    void reject(long position, String reason, DriverConductor conductor, long nowNs) {
        conductor.onPublicationError(this.registrationId, -1L, this.sessionId(), this.streamId(), -1L, -1L, IPC_SRC_ADDRESS, ErrorCode.IMAGE_REJECTED.value(), reason);
        if (!this.inCoolDown) {
            LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)false);
            conductor.unlinkIpcSubscriptions(this);
            CloseHelper.closeAll((ErrorHandler)this.errorHandler, (AutoCloseable[])this.subscriberPositions);
            this.subscriberPositions = EMPTY_POSITIONS;
            this.untetheredSubscriptions.clear();
            this.inCoolDown = true;
        }
        this.coolDownExpireTimeNs = nowNs + this.imageLivenessTimeoutNs;
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition, long nowNs) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, subscriberPosition, nowNs));
        }
        LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)true);
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        this.updatePublisherPositionAndLimit();
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
        if (this.subscriberPositions.length == 0) {
            LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)false);
        }
        if (!subscriptionLink.isTether()) {
            int lastIndex;
            for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
                if (this.untetheredSubscriptions.get((int)i).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove(this.untetheredSubscriptions, (int)i, (int)lastIndex);
                break;
            }
        }
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        switch (this.state) {
            case ACTIVE: {
                if (LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.metaDataBuffer)) {
                    long revokedPos = this.producerPosition();
                    this.publisherLimit.setRelease(revokedPos);
                    LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)this.metaDataBuffer, (long)revokedPos);
                    LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)false);
                    conductor.transitionToLinger(this);
                    this.state = State.LINGER;
                    IpcPublication.logRevoke(revokedPos, this.sessionId(), this.streamId(), this.channel());
                    this.publicationsRevoked.increment();
                    break;
                }
                long producerPosition = this.producerPosition();
                this.publisherPos.setRelease(producerPosition);
                if (!this.isExclusive) {
                    this.checkForBlockedPublisher(producerPosition, timeNs);
                }
                this.checkUntetheredSubscriptions(timeNs, conductor);
                this.checkCoolDownStatus(timeNs, conductor);
                break;
            }
            case DRAINING: {
                long producerPosition = this.producerPosition();
                this.publisherPos.setRelease(producerPosition);
                if (this.isDrained(producerPosition)) {
                    conductor.transitionToLinger(this);
                    this.state = State.LINGER;
                    break;
                }
                if (!LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.metaDataBuffer, (long)this.consumerPosition, (int)this.termBufferLength)) break;
                this.unblockedPublications.incrementRelease();
                break;
            }
            case LINGER: {
                if (0 != this.refCount) break;
                conductor.cleanupIpcPublication(this);
                this.reachedEndOfLife = true;
                this.state = State.DONE;
                break;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    void revoke() {
        LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.metaDataBuffer, (boolean)true);
    }

    void incRef() {
        ++this.refCount;
    }

    void decRef() {
        if (0 == --this.refCount) {
            long producerPosition = this.producerPosition();
            this.publisherLimit.setRelease(producerPosition);
            LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)this.metaDataBuffer, (long)producerPosition);
            if (!LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.metaDataBuffer)) {
                this.state = State.DRAINING;
            }
        }
    }

    int updatePublisherPositionAndLimit() {
        int workCount = 0;
        if (State.ACTIVE == this.state) {
            long producerPosition = this.producerPosition();
            this.publisherPos.setRelease(producerPosition);
            if (this.subscriberPositions.length > 0) {
                long newLimitPosition;
                long minSubscriberPosition = Long.MAX_VALUE;
                long maxSubscriberPosition = this.consumerPosition;
                for (ReadablePosition subscriberPosition : this.subscriberPositions) {
                    long position = subscriberPosition.getVolatile();
                    minSubscriberPosition = Math.min(minSubscriberPosition, position);
                    maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
                }
                if (maxSubscriberPosition > this.consumerPosition) {
                    this.consumerPosition = maxSubscriberPosition;
                }
                if ((newLimitPosition = minSubscriberPosition + (long)this.termWindowLength) >= this.tripLimit) {
                    this.cleanBufferTo(minSubscriberPosition);
                    this.publisherLimit.setRelease(newLimitPosition);
                    this.tripLimit = newLimitPosition + (long)this.tripGain;
                    workCount = 1;
                }
            } else if (this.publisherLimit.get() > this.consumerPosition) {
                this.tripLimit = this.consumerPosition;
                this.publisherLimit.setRelease(this.consumerPosition);
                this.cleanBufferTo(this.consumerPosition);
                workCount = 1;
            }
        }
        return workCount;
    }

    long joinPosition() {
        long position = this.consumerPosition;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            position = Math.min(subscriberPosition.getVolatile(), position);
        }
        return position;
    }

    long producerPosition() {
        long rawTail = LogBufferDescriptor.rawTailVolatile((UnsafeBuffer)this.metaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset((long)rawTail, (long)this.termBufferLength);
        return LogBufferDescriptor.computePosition((int)LogBufferDescriptor.termId((long)rawTail), (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
    }

    long consumerPosition() {
        return this.consumerPosition;
    }

    State state() {
        return this.state;
    }

    boolean isAcceptingSubscriptions() {
        return !this.inCoolDown && (State.ACTIVE == this.state || State.DRAINING == this.state && !this.isDrained(this.producerPosition()));
    }

    private void checkUntetheredSubscriptions(long nowNs, DriverConductor conductor) {
        int lastIndex;
        long untetheredWindowLimit = this.consumerPosition - (long)this.termWindowLength + (long)(this.termWindowLength >> 2);
        for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
            UntetheredSubscription untethered = this.untetheredSubscriptions.get(i);
            if (UntetheredSubscription.State.ACTIVE == untethered.state) {
                if (untethered.position.getVolatile() > untetheredWindowLimit) {
                    untethered.timeOfLastUpdateNs = nowNs;
                    continue;
                }
                if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue;
                conductor.notifyUnavailableImageLink(this.registrationId, untethered.subscriptionLink);
                untethered.state(UntetheredSubscription.State.LINGER, nowNs, this.streamId, this.sessionId);
                continue;
            }
            if (UntetheredSubscription.State.LINGER == untethered.state) {
                if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue;
                this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)untethered.position);
                untethered.state(UntetheredSubscription.State.RESTING, nowNs, this.streamId, this.sessionId);
                continue;
            }
            if (UntetheredSubscription.State.RESTING != untethered.state || untethered.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - nowNs > 0L) continue;
            long joinPosition = this.joinPosition();
            this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)untethered.position);
            conductor.notifyAvailableImageLink(this.registrationId, this.sessionId, untethered.subscriptionLink, untethered.position.id(), joinPosition, this.rawLog.fileName(), "aeron:ipc");
            untethered.state(UntetheredSubscription.State.ACTIVE, nowNs, this.streamId, this.sessionId);
            LogBufferDescriptor.isConnected((UnsafeBuffer)this.metaDataBuffer, (boolean)true);
        }
    }

    private void checkCoolDownStatus(long timeNs, DriverConductor conductor) {
        if (this.inCoolDown && this.coolDownExpireTimeNs < timeNs) {
            this.inCoolDown = false;
            conductor.linkIpcSubscriptions(this);
            this.coolDownExpireTimeNs = 0L;
        }
    }

    private boolean isDrained(long producerPosition) {
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            if (subscriberPosition.getVolatile() >= producerPosition) continue;
            return false;
        }
        return true;
    }

    private void checkForBlockedPublisher(long producerPosition, long timeNs) {
        long consumerPosition = this.consumerPosition;
        if (consumerPosition == this.lastConsumerPosition && this.isPossiblyBlocked(producerPosition, consumerPosition)) {
            if (this.timeOfLastConsumerPositionUpdateNs + this.unblockTimeoutNs - timeNs < 0L && LogBufferUnblocker.unblock((UnsafeBuffer[])this.termBuffers, (UnsafeBuffer)this.metaDataBuffer, (long)consumerPosition, (int)this.termBufferLength)) {
                this.unblockedPublications.incrementRelease();
            }
        } else {
            this.timeOfLastConsumerPositionUpdateNs = timeNs;
            this.lastConsumerPosition = consumerPosition;
        }
    }

    private boolean isPossiblyBlocked(long producerPosition, long consumerPosition) {
        int expectedTermCount;
        int producerTermCount = LogBufferDescriptor.activeTermCount((UnsafeBuffer)this.metaDataBuffer);
        if (producerTermCount != (expectedTermCount = (int)(consumerPosition >> this.positionBitsToShift))) {
            return true;
        }
        return producerPosition > consumerPosition;
    }

    private void cleanBufferTo(long position) {
        long cleanPosition = this.cleanPosition;
        if (position > cleanPosition) {
            UnsafeBuffer dirtyTermBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
            int bytesForCleaning = (int)(position - cleanPosition);
            int bufferCapacity = this.termBufferLength;
            int termOffset = (int)cleanPosition & bufferCapacity - 1;
            int length = Math.min(bytesForCleaning, bufferCapacity - termOffset);
            dirtyTermBuffer.setMemory(termOffset + 8, length - 8, (byte)0);
            dirtyTermBuffer.putLongRelease(termOffset, 0L);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    private static void logRevoke(long revokedPos, int sessionId, int streamId, String channel) {
    }

    static enum State {
        ACTIVE,
        DRAINING,
        LINGER,
        DONE;

    }
}

