/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossHandler;
import io.aeron.logbuffer.TermGapScanner;
import org.agrona.concurrent.UnsafeBuffer;

public class LossDetector
implements TermGapScanner.GapHandler {
    private long deadlineNs = -1L;
    private int scannedTermId;
    private int scannedTermOffset = -1;
    private int scannedLength;
    private int activeTermId;
    private int activeTermOffset = -1;
    private int activeLength;
    private final FeedbackDelayGenerator delayGenerator;
    private final LossHandler lossHandler;

    public LossDetector(FeedbackDelayGenerator delayGenerator, LossHandler lossHandler) {
        this.delayGenerator = delayGenerator;
        this.lossHandler = lossHandler;
    }

    public long scan(UnsafeBuffer termBuffer, long rebuildPosition, long hwmPosition, long nowNs, int termLengthMask, int positionBitsToShift, int initialTermId) {
        boolean lossFound = false;
        int rebuildOffset = (int)(rebuildPosition & (long)termLengthMask);
        if (rebuildPosition < hwmPosition) {
            int rebuildTermCount = (int)(rebuildPosition >>> positionBitsToShift);
            int hwmTermCount = (int)(hwmPosition >>> positionBitsToShift);
            int rebuildTermId = initialTermId + rebuildTermCount;
            int hwmTermOffset = (int)(hwmPosition & (long)termLengthMask);
            int limitOffset = rebuildTermCount == hwmTermCount ? hwmTermOffset : termLengthMask + 1;
            if ((rebuildOffset = TermGapScanner.scanForGap((UnsafeBuffer)termBuffer, (int)rebuildTermId, (int)rebuildOffset, (int)limitOffset, (TermGapScanner.GapHandler)this)) < limitOffset) {
                if (this.scannedTermOffset != this.activeTermOffset || this.scannedTermId != this.activeTermId || this.scannedLength != this.activeLength) {
                    this.activateGap(nowNs);
                    lossFound = true;
                }
                this.checkTimerExpiry(nowNs);
            }
        }
        return LossDetector.pack(rebuildOffset, lossFound);
    }

    public void onGap(int termId, int offset, int length) {
        this.scannedTermId = termId;
        this.scannedTermOffset = offset;
        this.scannedLength = length;
    }

    public static long pack(int rebuildOffset, boolean lossFound) {
        return (long)rebuildOffset << 32 | (long)(lossFound ? 1 : 0);
    }

    public static boolean lossFound(long scanOutcome) {
        return (int)scanOutcome != 0;
    }

    public static int rebuildOffset(long scanOutcome) {
        return (int)(scanOutcome >>> 32);
    }

    private void activateGap(long nowNs) {
        this.activeTermId = this.scannedTermId;
        this.activeTermOffset = this.scannedTermOffset;
        this.activeLength = this.scannedLength;
        this.deadlineNs = nowNs + this.delayGenerator.generateDelayNs();
    }

    private void checkTimerExpiry(long nowNs) {
        if (this.deadlineNs - nowNs <= 0L) {
            this.lossHandler.onGapDetected(this.activeTermId, this.activeTermOffset, this.activeLength);
            this.deadlineNs = nowNs + this.delayGenerator.retryDelayNs();
        }
    }
}

