/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import org.agrona.collections.Long2LongHashMap;

class ReceiverLivenessTracker {
    private static final int MISSING_VALUE = -1;
    private final Long2LongHashMap lastSmTimestampNsByReceiverIdMap = new Long2LongHashMap(-1L);

    ReceiverLivenessTracker() {
    }

    public boolean hasReceivers() {
        return !this.lastSmTimestampNsByReceiverIdMap.isEmpty();
    }

    public void onStatusMessage(long receiverId, long nowNs) {
        this.lastSmTimestampNsByReceiverIdMap.put(receiverId, nowNs);
    }

    public boolean onRemoteClose(long receiverId) {
        return -1L != this.lastSmTimestampNsByReceiverIdMap.remove(receiverId);
    }

    public void onIdle(long nowNs, long timeoutNs) {
        long timeoutThresholdNs = nowNs - timeoutNs;
        Long2LongHashMap.EntryIterator iterator = this.lastSmTimestampNsByReceiverIdMap.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (iterator.getLongValue() > timeoutThresholdNs) continue;
            iterator.remove();
        }
    }
}

