/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.reports;

import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;

public final class LossReport {
    public static final int ENTRY_ALIGNMENT = 64;
    public static final int OBSERVATION_COUNT_OFFSET = 0;
    public static final int TOTAL_BYTES_LOST_OFFSET = 8;
    public static final int FIRST_OBSERVATION_OFFSET = 16;
    public static final int LAST_OBSERVATION_OFFSET = 24;
    public static final int SESSION_ID_OFFSET = 32;
    public static final int STREAM_ID_OFFSET = 36;
    public static final int CHANNEL_OFFSET = 40;
    private int nextRecordOffset = 0;
    private final AtomicBuffer buffer;

    public LossReport(AtomicBuffer buffer) {
        buffer.verifyAlignment();
        this.buffer = buffer;
    }

    public ReportEntry createEntry(long initialBytesLost, long timestampMs, int sessionId, int streamId, String channel, String source) {
        ReportEntry reportEntry = null;
        int requiredCapacity = 40 + BitUtil.align((int)(4 + channel.length()), (int)4) + 4 + source.length();
        if (requiredCapacity <= this.buffer.capacity() - this.nextRecordOffset) {
            int offset = this.nextRecordOffset;
            this.buffer.putLong(offset + 8, initialBytesLost);
            this.buffer.putLong(offset + 16, timestampMs);
            this.buffer.putLong(offset + 24, timestampMs);
            this.buffer.putInt(offset + 32, sessionId);
            this.buffer.putInt(offset + 36, streamId);
            int encodedChannelLength = this.buffer.putStringAscii(offset + 40, channel);
            this.buffer.putStringAscii(offset + 40 + BitUtil.align((int)encodedChannelLength, (int)4), source);
            this.buffer.putLongRelease(offset + 0, 1L);
            reportEntry = new ReportEntry(this.buffer, offset);
            this.nextRecordOffset += BitUtil.align((int)requiredCapacity, (int)64);
        }
        return reportEntry;
    }

    public String toString() {
        return "LossReport{nextRecordOffset=" + this.nextRecordOffset + ", buffer=" + String.valueOf(this.buffer) + "}";
    }

    public static final class ReportEntry {
        private final AtomicBuffer buffer;
        private final int offset;

        ReportEntry(AtomicBuffer buffer, int offset) {
            this.buffer = buffer;
            this.offset = offset;
        }

        public void recordObservation(long bytesLost, long timestampMs) {
            this.buffer.putLongRelease(this.offset + 24, timestampMs);
            this.buffer.getAndAddLong(this.offset + 8, bytesLost);
            this.buffer.getAndAddLong(this.offset + 0, 1L);
        }
    }
}

