/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.Aeron;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.status.RecordingPos;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.status.CountersReader;

public class ArchiveCreator {
    private static final String MESSAGE_PREFIX = "Message-Prefix-";
    private static final long CATALOG_CAPACITY = 131072L;
    private static final int TERM_LENGTH = 65536;
    private static final int SEGMENT_LENGTH = 131072;
    private static final int STREAM_ID = 33;
    private static int recordingNumber = 0;

    public static void main(String[] args) {
        String archiveDirName = Archive.Configuration.archiveDirName();
        File archiveDir = "aeron-archive".equals(archiveDirName) ? new File("archive") : new File(archiveDirName);
        MediaDriver.Context driverContext = new MediaDriver.Context().publicationTermBufferLength(65536).termBufferSparseFile(true).threadingMode(ThreadingMode.SHARED).errorHandler(Throwable::printStackTrace).spiesSimulateConnection(true).dirDeleteOnStart(true);
        Archive.Context archiveContext = new Archive.Context().catalogCapacity(131072L).segmentFileLength(131072).deleteArchiveOnStart(true).archiveDir(archiveDir).fileSyncLevel(0).threadingMode(ArchiveThreadingMode.SHARED);
        System.out.println("Creating basic archive at " + archiveContext.archiveDir());
        try (ArchivingMediaDriver ignore = ArchivingMediaDriver.launch((MediaDriver.Context)driverContext, (Archive.Context)archiveContext);
             Aeron aeron = Aeron.connect();
             AeronArchive aeronArchive = AeronArchive.connect((AeronArchive.Context)new AeronArchive.Context().aeron(aeron));){
            ArchiveCreator.createRecording(aeron, aeronArchive, 0L, 655361L);
            ArchiveCreator.createRecording(aeron, aeronArchive, 65600L, 393217L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void createRecording(Aeron aeron, AeronArchive aeronArchive, long startPosition, long targetPosition) {
        int initialTermId = 7;
        ChannelUriStringBuilder uriBuilder = new ChannelUriStringBuilder().media("udp").endpoint("localhost:" + ++recordingNumber).termLength(Integer.valueOf(65536));
        if (startPosition > 0L) {
            uriBuilder.initialPosition(startPosition, 7, 65536);
        }
        try (ExclusivePublication publication = aeronArchive.addRecordedExclusivePublication(uriBuilder.build(), 33);){
            CountersReader counters = aeron.countersReader();
            int counterId = ArchiveCreator.awaitRecordingCounterId(counters, publication.sessionId(), aeronArchive.archiveId());
            long recordingId = RecordingPos.getRecordingId((CountersReader)counters, (int)counterId);
            System.out.println("recordingId=" + recordingId + " position " + publication.position() + " to " + targetPosition);
            ArchiveCreator.offerToPosition((Publication)publication, targetPosition);
            ArchiveCreator.awaitPosition(counters, counterId, publication.position());
            aeronArchive.stopRecording((Publication)publication);
        }
    }

    private static void checkInterruptStatus() {
        if (Thread.interrupted()) {
            LangUtil.rethrowUnchecked((Throwable)new InterruptedException());
        }
    }

    private static int awaitRecordingCounterId(CountersReader counters, int sessionId, long archiveId) {
        int counterId;
        while (-1 == (counterId = RecordingPos.findCounterIdBySession((CountersReader)counters, (int)sessionId, (long)archiveId))) {
            Thread.yield();
            ArchiveCreator.checkInterruptStatus();
        }
        return counterId;
    }

    private static void offerToPosition(Publication publication, long minimumPosition) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
        int i = 0;
        while (publication.position() < minimumPosition) {
            int length = buffer.putStringWithoutLengthAscii(0, MESSAGE_PREFIX + i);
            while (publication.offer((DirectBuffer)buffer, 0, length) <= 0L) {
                Thread.yield();
                ArchiveCreator.checkInterruptStatus();
            }
            ++i;
        }
    }

    private static void awaitPosition(CountersReader counters, int counterId, long position) {
        while (counters.getCounterValue(counterId) < position) {
            if (counters.getCounterState(counterId) != 1) {
                throw new IllegalStateException("count not active: " + counterId);
            }
            Thread.yield();
            ArchiveCreator.checkInterruptStatus();
        }
    }
}

