/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.echo;

import io.aeron.Aeron;
import io.aeron.driver.MediaDriver;
import io.aeron.samples.echo.Provisioning;
import io.aeron.samples.echo.api.ProvisioningMBean;
import java.lang.management.ManagementFactory;
import java.util.Objects;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.agrona.CloseHelper;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ShutdownSignalBarrier;

public final class ProvisioningServerMain
implements Agent,
AutoCloseable {
    private final MediaDriver driver;
    private final Aeron aeron;
    private final Provisioning provisioning;
    private final AgentRunner runner;
    private volatile ObjectName beanName = null;

    private ProvisioningServerMain(MediaDriver driver, Aeron aeron) {
        this.driver = driver;
        this.aeron = Objects.requireNonNull(aeron);
        this.provisioning = new Provisioning(aeron);
        this.runner = new AgentRunner((IdleStrategy)new BackoffIdleStrategy(), Throwable::printStackTrace, null, (Agent)this);
    }

    public static void main(String[] args) {
        ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
        try (ProvisioningServerMain ignore = ProvisioningServerMain.launch(new Aeron.Context());){
            barrier.await();
            System.out.println("Shutdown Provisioning Server...");
        }
    }

    public static ProvisioningServerMain launch(Aeron.Context context) {
        MediaDriver driver = null;
        if (null == System.getProperty("aeron.dir")) {
            driver = MediaDriver.launchEmbedded();
            context.aeronDirectoryName(driver.aeronDirectoryName());
        }
        Aeron aeron = Aeron.connect((Aeron.Context)context);
        ProvisioningServerMain provisioningServerMain = new ProvisioningServerMain(driver, aeron);
        AgentRunner.startOnThread((AgentRunner)provisioningServerMain.runner);
        return provisioningServerMain;
    }

    public void onStart() {
        try {
            this.beanName = new ObjectName("io.aeron:type=Provisioning,name=testing");
            StandardMBean object = new StandardMBean(this.provisioning, ProvisioningMBean.class);
            ManagementFactory.getPlatformMBeanServer().registerMBean(object, this.beanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    public int doWork() {
        return this.provisioning.doWork();
    }

    public String roleName() {
        return "EchoProvisioningServer";
    }

    @Override
    public void close() {
        if (null != this.beanName) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.beanName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                // empty catch block
            }
        }
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.runner, this.aeron, this.driver});
    }
}

