/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.SystemUtil;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.SigInt;
import org.agrona.hints.ThreadHints;

public class ReceiveSendUdpPong {
    public static void main(String[] args) throws IOException {
        int numChannels = 1;
        if (1 <= args.length) {
            numChannels = Integer.parseInt(args[0]);
        }
        String remoteHost = "localhost";
        if (2 <= args.length) {
            remoteHost = args[1];
        }
        if (SystemUtil.isWindows()) {
            HighResolutionTimer.enable();
        }
        System.out.printf("Number of channels: %d, Remote host: %s%n", numChannels, remoteHost);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        DatagramChannel[] receiveChannels = new DatagramChannel[numChannels];
        for (int i = 0; i < receiveChannels.length; ++i) {
            receiveChannels[i] = DatagramChannel.open();
            Common.init(receiveChannels[i]);
            receiveChannels[i].bind(new InetSocketAddress("0.0.0.0", 20124 + i));
        }
        InetSocketAddress sendAddress = new InetSocketAddress(remoteHost, 20123);
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (true) {
            buffer.clear();
            boolean available = false;
            block2: while (!available) {
                ThreadHints.onSpinWait();
                if (!running.get()) {
                    return;
                }
                for (int i = receiveChannels.length - 1; i >= 0; --i) {
                    if (null == receiveChannels[i].receive(buffer)) continue;
                    available = true;
                    continue block2;
                }
            }
            buffer.flip();
            int length = buffer.remaining();
            long receivedSequenceNumber = buffer.getLong(0);
            long receivedTimestamp = buffer.getLong(8);
            buffer.clear();
            buffer.putLong(receivedSequenceNumber);
            buffer.putLong(receivedTimestamp);
            buffer.position(length);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
        }
    }
}

