/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.response;

import io.aeron.Aeron;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.ConcurrentPublication;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.Objects;
import java.util.function.Function;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;

public class ResponseServer
implements AutoCloseable,
Agent {
    private final Aeron aeron;
    private final Long2ObjectHashMap<ResponseSession> clientToPublicationMap = new Long2ObjectHashMap();
    private final OneToOneConcurrentArrayQueue<Image> availableImages = new OneToOneConcurrentArrayQueue(1024);
    private final OneToOneConcurrentArrayQueue<Image> unavailableImages = new OneToOneConcurrentArrayQueue(1024);
    private final Function<Image, ResponseHandler> handlerFactory;
    private final int requestStreamId;
    private final int responseStreamId;
    private final ChannelUriStringBuilder requestUriBuilder;
    private final ChannelUriStringBuilder responseUriBuilder;
    private final ControlledFragmentAssembler requestAssembler = new ControlledFragmentAssembler(this::onControlledRequestMessage);
    private Subscription serverSubscription;

    public ResponseServer(Aeron aeron, Function<Image, ResponseHandler> handlerFactory, String requestEndpoint, int requestStreamId, String responseControl, int responseStreamId, String requestChannel, String responseChannel) {
        this.aeron = aeron;
        this.handlerFactory = handlerFactory;
        this.requestStreamId = requestStreamId;
        this.responseStreamId = responseStreamId;
        Objects.requireNonNull(requestEndpoint, "subscriptionEndpoint must not be null");
        Objects.requireNonNull(responseControl, "responseEndpoint must not be null");
        this.requestUriBuilder = null == requestChannel ? new ChannelUriStringBuilder() : new ChannelUriStringBuilder(requestChannel);
        this.requestUriBuilder.media("udp").endpoint(requestEndpoint).responseEndpoint(responseControl);
        this.responseUriBuilder = null == responseChannel ? new ChannelUriStringBuilder() : new ChannelUriStringBuilder(responseChannel);
        this.responseUriBuilder.media("udp").controlMode("response").controlEndpoint(responseControl);
    }

    public int doWork() {
        Image image;
        int workCount = 0;
        if (null == this.serverSubscription) {
            this.serverSubscription = this.aeron.addSubscription(this.requestUriBuilder.build(), this.requestStreamId, this::enqueueAvailableImage, this::enqueueUnavailableImage);
            ++workCount;
        }
        while (null != (image = (Image)this.availableImages.poll())) {
            ++workCount;
            this.getOrCreateSession(image);
        }
        while (null != (image = (Image)this.unavailableImages.poll())) {
            ++workCount;
            this.removeSession(image);
        }
        return workCount += this.serverSubscription.controlledPoll((ControlledFragmentHandler)this.requestAssembler, 1);
    }

    public int sessionCount() {
        return this.clientToPublicationMap.size();
    }

    @Override
    public void close() {
        CloseHelper.quietClose((AutoCloseable)this.serverSubscription);
        this.clientToPublicationMap.values().forEach(CloseHelper::quietClose);
    }

    public String roleName() {
        return "ResponseServer";
    }

    private void enqueueAvailableImage(Image image) {
        if (!this.availableImages.offer((Object)image)) {
            throw new RuntimeException("Unable to enqueue new image");
        }
    }

    private void enqueueUnavailableImage(Image image) {
        if (!this.unavailableImages.offer((Object)image)) {
            throw new RuntimeException("Unable to enqueue removed image");
        }
    }

    private ControlledFragmentHandler.Action onControlledRequestMessage(DirectBuffer buffer, int offset, int length, Header header) {
        ResponseSession session = this.getOrCreateSession((Image)header.context());
        boolean processed = session.process(buffer, offset, length, header);
        return processed ? ControlledFragmentHandler.Action.CONTINUE : ControlledFragmentHandler.Action.ABORT;
    }

    private ResponseSession getOrCreateSession(Image image) {
        ResponseSession session = (ResponseSession)this.clientToPublicationMap.get(image.correlationId());
        if (null == session) {
            ConcurrentPublication responsePublication = this.aeron.addPublication(this.responseUriBuilder.responseCorrelationId(Long.valueOf(image.correlationId())).build(), this.responseStreamId);
            ResponseHandler handler = this.handlerFactory.apply(image);
            session = new ResponseSession((Publication)responsePublication, handler);
            this.clientToPublicationMap.put(image.correlationId(), (Object)session);
        }
        return session;
    }

    private void removeSession(Image image) {
        this.requestAssembler.freeSessionBuffer(image.sessionId());
        ResponseSession session = (ResponseSession)this.clientToPublicationMap.remove(image.correlationId());
        CloseHelper.quietClose((AutoCloseable)session);
    }

    private static final class ResponseSession
    implements AutoCloseable {
        private final Publication publication;
        private final ResponseHandler handler;

        ResponseSession(Publication publication, ResponseHandler handler) {
            this.publication = publication;
            this.handler = handler;
        }

        public boolean process(DirectBuffer buffer, int offset, int length, Header header) {
            return this.handler.onMessage(buffer, offset, length, header, this.publication);
        }

        @Override
        public void close() {
            CloseHelper.close((AutoCloseable)this.publication);
        }
    }

    public static interface ResponseHandler {
        public boolean onMessage(DirectBuffer var1, int var2, int var3, Header var4, Publication var5);
    }
}

