/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.exceptions.AeronException;
import io.aeron.samples.SamplesUtil;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.charset.StandardCharsets;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import org.agrona.concurrent.status.CountersReader;

public final class CncFileReader
implements AutoCloseable {
    private boolean isClosed = false;
    private final int driverPid;
    private final int cncVersion;
    private final String cncSemanticVersion;
    private final MappedByteBuffer cncByteBuffer;
    private final CountersReader countersReader;
    private final UnsafeBuffer toDriverBuffer;

    private CncFileReader(MappedByteBuffer cncByteBuffer) {
        this.cncByteBuffer = cncByteBuffer;
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
        this.driverPid = cncMetaDataBuffer.getInt(CncFileDescriptor.pidOffset((int)0));
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        try {
            CncFileDescriptor.checkVersion((int)cncVersion);
        }
        catch (AeronException e) {
            BufferUtil.free((ByteBuffer)cncByteBuffer);
            throw e;
        }
        this.cncVersion = cncVersion;
        this.cncSemanticVersion = SemanticVersion.toString((int)cncVersion);
        this.toDriverBuffer = CncFileDescriptor.createToDriverBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaDataBuffer);
        this.countersReader = new CountersReader((AtomicBuffer)CncFileDescriptor.createCountersMetaDataBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaDataBuffer), (AtomicBuffer)CncFileDescriptor.createCountersValuesBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaDataBuffer), StandardCharsets.US_ASCII);
    }

    public static CncFileReader map() {
        File cncFile = CommonContext.newDefaultCncFile();
        MappedByteBuffer cncByteBuffer = SamplesUtil.mapExistingFileReadOnly(cncFile);
        return new CncFileReader(cncByteBuffer);
    }

    public int cncVersion() {
        return this.cncVersion;
    }

    public String semanticVersion() {
        return this.cncSemanticVersion;
    }

    public CountersReader countersReader() {
        return this.countersReader;
    }

    public long driverHeartbeatMs() {
        int timestampOffset = this.toDriverBuffer.capacity() - RingBufferDescriptor.TRAILER_LENGTH + RingBufferDescriptor.CONSUMER_HEARTBEAT_OFFSET;
        return this.toDriverBuffer.getLongVolatile(timestampOffset);
    }

    public int driverPid() {
        return this.driverPid;
    }

    public long driverHeartbeatAgeMs() {
        return System.currentTimeMillis() - this.driverHeartbeatMs();
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            BufferUtil.free((ByteBuffer)this.cncByteBuffer);
        }
    }
}

