/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.DriverProxy;
import io.aeron.exceptions.AeronException;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Date;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public class DriverTool {
    public static void main(String[] args) {
        boolean printPidOnly = false;
        boolean terminateDriver = false;
        if (0 != args.length) {
            DriverTool.checkForHelp(args);
            if (args[0].equals("pid")) {
                printPidOnly = true;
            } else if (args[0].equals("terminate")) {
                terminateDriver = true;
            }
        }
        File cncFile = CommonContext.newDefaultCncFile();
        MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile((File)cncFile, (String)"cnc");
        UnsafeBuffer cncMetaData = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)cncByteBuffer);
        int cncVersion = cncMetaData.getInt(CncFileDescriptor.cncVersionOffset((int)0));
        CncFileDescriptor.checkVersion((int)cncVersion);
        ManyToOneRingBuffer toDriver = new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer((ByteBuffer)cncByteBuffer, (DirectBuffer)cncMetaData));
        if (printPidOnly) {
            System.out.println(CncFileDescriptor.pid((DirectBuffer)cncMetaData));
        } else if (terminateDriver) {
            DriverProxy driverProxy = new DriverProxy((RingBuffer)toDriver, toDriver.nextCorrelationId());
            if (!driverProxy.terminateDriver(null, 0, 0)) {
                throw new AeronException("could not send termination request.");
            }
        } else {
            System.out.println("Command `n Control file: " + cncFile);
            System.out.println("Version: " + cncVersion + ", PID: " + CncFileDescriptor.pid((DirectBuffer)cncMetaData));
            DriverTool.printDateActivityAndStartTimestamps(CncFileDescriptor.startTimestampMs((DirectBuffer)cncMetaData), toDriver.consumerHeartbeatTime());
        }
    }

    private static void printDateActivityAndStartTimestamps(long startTimestamp, long activityTimestamp) {
        System.out.format("%1$tH:%1$tM:%1$tS (start: %2$tF %2$tH:%2$tM:%2$tS, activity: %3$tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(startTimestamp), new Date(activityTimestamp));
    }

    private static void checkForHelp(String[] args) {
        for (String arg : args) {
            if (!"-?".equals(arg) && !"-h".equals(arg) && !"-help".equals(arg)) continue;
            System.out.format("Usage: [-Daeron.dir=<directory containing CnC file>] DriverTool <pid> <terminate>%n    pid: prints PID of driver only%n    terminate: request the driver to terminate%n", new Object[0]);
            System.out.flush();
            System.exit(0);
        }
    }
}

