/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.SigInt;

public class MultipleSubscribersWithFragmentAssembly {
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final int STREAM_ID_1 = SampleConfiguration.STREAM_ID;
    private static final int STREAM_ID_2 = SampleConfiguration.STREAM_ID + 1;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;

    public static void main(String[] args) {
        System.out.format("Subscribing to %s on stream ID %d and stream ID %d%n", CHANNEL, STREAM_ID_1, STREAM_ID_2);
        Aeron.Context ctx = new Aeron.Context().availableImageHandler(MultipleSubscribersWithFragmentAssembly::eventAvailableImage).unavailableImageHandler(MultipleSubscribersWithFragmentAssembly::eventUnavailableImage);
        FragmentAssembler assembler1 = new FragmentAssembler(MultipleSubscribersWithFragmentAssembly.reassembledMessage1(STREAM_ID_1));
        FragmentAssembler assembler2 = new FragmentAssembler(MultipleSubscribersWithFragmentAssembly.reassembledMessage2(STREAM_ID_2));
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Subscription subscription1 = aeron.addSubscription(CHANNEL, STREAM_ID_1);
             Subscription subscription2 = aeron.addSubscription(CHANNEL, STREAM_ID_2);){
            BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(100L, 10L, TimeUnit.MICROSECONDS.toNanos(1L), TimeUnit.MICROSECONDS.toNanos(100L));
            int idleCount = 0;
            while (running.get()) {
                int fragmentsRead2;
                int fragmentsRead1 = subscription1.poll((FragmentHandler)assembler1, FRAGMENT_COUNT_LIMIT);
                if (fragmentsRead1 + (fragmentsRead2 = subscription2.poll((FragmentHandler)assembler2, FRAGMENT_COUNT_LIMIT)) == 0) {
                    idleStrategy.idle(idleCount++);
                    continue;
                }
                idleCount = 0;
            }
            System.out.println("Shutting down...");
        }
    }

    public static void eventAvailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.format("new image on %s streamId %x sessionId %x from %s%n", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity());
    }

    public static void eventUnavailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.format("inactive image on %s streamId %d sessionId %x%n", subscription.channel(), subscription.streamId(), image.sessionId());
    }

    public static FragmentHandler reassembledMessage1(int streamId) {
        return (buffer, offset, length, header) -> {
            System.out.format("message to stream %d from session %x term id %x term offset %d (%d@%d)%n", streamId, header.sessionId(), header.termId(), header.termOffset(), length, offset);
            if (length != 10000) {
                System.out.format("Received message was not assembled properly; received length was %d, but was expecting 10000%n", length);
            }
        };
    }

    public static FragmentHandler reassembledMessage2(int streamId) {
        return (buffer, offset, length, header) -> {
            System.out.format("message to stream %d from session %x term id %x term offset %d (%d@%d)%n", streamId, header.sessionId(), header.termId(), header.termOffset(), length, offset);
            if (length != 9000) {
                System.out.format("Received message was not assembled properly; received length was %d, but was expecting 9000%n", length);
            }
        };
    }
}

