/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.client.ReplicationParams;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.samples.archive.RecordingDescriptor;
import io.aeron.samples.archive.RecordingDescriptorCollector;
import io.aeron.samples.archive.RecordingSignalCapture;
import java.util.Objects;
import java.util.Scanner;
import org.agrona.Strings;
import org.agrona.SystemUtil;

public final class RecordingReplicator {
    public static final String SOURCE_RECORDING_ID_PROP_NAME = "aeron.sample.archive.replicate.source.recording.id";
    public static final String DESTINATION_RECORDING_ID_PROP_NAME = "aeron.sample.archive.replicate.destination.recording.id";
    public static final String SOURCE_ARCHIVE_CONTROL_REQUEST_CHANNEL = "aeron.sample.archive.replicate.source.control.request.channel";
    public static final String SOURCE_ARCHIVE_CONTROL_REQUEST_STREAM_ID = "aeron.sample.archive.replicate.source.control.request.stream.id";
    public static final String REPLICATION_CHANNEL = "aeron.sample.archive.replicate.replication.channel";
    private final AeronArchive aeronArchive;
    private final RecordingSignalCapture signalCapture;
    private final long srcRecordingId;
    private final String srcArchiveRequestChannel;
    private final int srcArchiveRequestStreamId;
    private final long dstRecordingId;
    private final String replicationChannel;

    public RecordingReplicator(AeronArchive aeronArchive, long srcRecordingId, long dstRecordingId, String srcArchiveRequestChannel, int srcArchiveRequestStreamId, String replicationChannel) {
        this.aeronArchive = aeronArchive;
        this.signalCapture = (RecordingSignalCapture)aeronArchive.context().recordingSignalConsumer();
        if (null == this.signalCapture) {
            throw new IllegalArgumentException("RecordingSignalConsumer not configured!");
        }
        if (-1L == srcRecordingId) {
            throw new IllegalArgumentException("aeron.sample.archive.replicate.source.recording.id must be specified");
        }
        this.srcRecordingId = srcRecordingId;
        this.srcArchiveRequestChannel = Objects.requireNonNull(RecordingReplicator.trimToNull(srcArchiveRequestChannel), SOURCE_ARCHIVE_CONTROL_REQUEST_CHANNEL);
        this.srcArchiveRequestStreamId = srcArchiveRequestStreamId;
        this.dstRecordingId = dstRecordingId;
        this.replicationChannel = RecordingReplicator.trimToNull(replicationChannel);
    }

    public long replicate() {
        if (-1L != this.dstRecordingId) {
            RecordingDescriptorCollector recordingDescriptorCollector = new RecordingDescriptorCollector(1);
            if (1 != this.aeronArchive.listRecording(this.dstRecordingId, recordingDescriptorCollector.reset())) {
                throw new IllegalArgumentException("unknown destination recording id: " + this.dstRecordingId);
            }
            RecordingDescriptor recordingDescriptor = recordingDescriptorCollector.descriptors().get(0).retain();
            this.signalCapture.reset();
            this.aeronArchive.truncateRecording(this.dstRecordingId, recordingDescriptor.startPosition());
            this.signalCapture.awaitSignalForRecordingId(this.aeronArchive, this.dstRecordingId, RecordingSignal.DELETE);
        }
        ReplicationParams replicationParams = new ReplicationParams().replicationChannel(this.replicationChannel).dstRecordingId(this.dstRecordingId);
        long replicationId = this.aeronArchive.replicate(this.srcRecordingId, this.srcArchiveRequestStreamId, this.srcArchiveRequestChannel, replicationParams);
        this.signalCapture.reset();
        this.signalCapture.awaitSignalForCorrelationId(this.aeronArchive, replicationId, RecordingSignal.SYNC);
        long recordingId = this.signalCapture.recordingId();
        this.signalCapture.reset();
        this.signalCapture.awaitSignalForCorrelationId(this.aeronArchive, replicationId, RecordingSignal.REPLICATE_END);
        return recordingId;
    }

    public static void main(String[] args) {
        SystemUtil.loadPropertiesFiles((String[])args);
        long srcRecordingId = Long.parseLong(SystemUtil.getProperty((String)SOURCE_RECORDING_ID_PROP_NAME));
        long dstRecordingId = Long.parseLong(SystemUtil.getProperty((String)DESTINATION_RECORDING_ID_PROP_NAME));
        String srcArchiveRequestChannel = SystemUtil.getProperty((String)SOURCE_ARCHIVE_CONTROL_REQUEST_CHANNEL);
        int srcArchiveRequestStreamId = Integer.parseInt(SystemUtil.getProperty((String)SOURCE_ARCHIVE_CONTROL_REQUEST_STREAM_ID, (String)String.valueOf(10)));
        String replicationChannel = SystemUtil.getProperty((String)REPLICATION_CHANNEL);
        if (-1L != dstRecordingId) {
            System.out.println("Destination recording=" + dstRecordingId + " will be replaced with source recording=" + srcRecordingId + ". Continue? (y/n)");
            String answer = new Scanner(System.in).nextLine();
            if (!"y".equalsIgnoreCase(answer) && !"yes".equalsIgnoreCase(answer)) {
                System.out.println("Action aborted!");
                System.exit(-1);
                return;
            }
        }
        RecordingSignalCapture signalCapture = new RecordingSignalCapture();
        try (AeronArchive aeronArchive = AeronArchive.connect((AeronArchive.Context)new AeronArchive.Context().recordingSignalConsumer((RecordingSignalConsumer)signalCapture));){
            RecordingReplicator replicator = new RecordingReplicator(aeronArchive, srcRecordingId, dstRecordingId, srcArchiveRequestChannel, srcArchiveRequestStreamId, replicationChannel);
            long newRecordingId = replicator.replicate();
            System.out.println("Source recordingId=" + srcRecordingId + " replicated to the destination recordingId=" + newRecordingId + ".");
        }
    }

    private static String trimToNull(String value) {
        if (Strings.isEmpty((String)value)) {
            return null;
        }
        String result = value.trim();
        return result.isEmpty() ? null : result;
    }
}

