/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.driver.status.StreamCounter;
import io.aeron.samples.SamplesUtil;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.agrona.collections.Hashing;
import org.agrona.collections.Object2ObjectHashMap;
import org.agrona.concurrent.status.CountersReader;

public final class StreamStat {
    private static final Comparator<StreamCompositeKey> LINES_COMPARATOR = Comparator.comparingLong(StreamCompositeKey::sessionId).thenComparingInt(StreamCompositeKey::streamId).thenComparing(StreamCompositeKey::channel);
    private final CountersReader counters;

    public static void main(String[] args) {
        CountersReader counters = SamplesUtil.mapCounters();
        StreamStat streamStat = new StreamStat(counters);
        streamStat.print(System.out);
    }

    public StreamStat(CountersReader counters) {
        this.counters = counters;
    }

    public Map<StreamCompositeKey, List<StreamPosition>> snapshot() {
        TreeMap<StreamCompositeKey, List<StreamPosition>> streams = new TreeMap<StreamCompositeKey, List<StreamPosition>>(LINES_COMPARATOR);
        Object2ObjectHashMap fullChannelByStream = new Object2ObjectHashMap();
        this.counters.forEach((counterId, typeId, keyBuffer, label) -> {
            if (typeId >= 1 && typeId <= 5 || typeId == 9 || typeId == 12) {
                String fullChannel;
                int channelLength = keyBuffer.getInt(16, ByteOrder.LITTLE_ENDIAN);
                String channel = keyBuffer.getStringWithoutLengthAscii(20, channelLength);
                int uriIndex = label.indexOf("aeron:");
                if (uriIndex >= 0) {
                    int joinPositionIndex = -1;
                    fullChannel = 4 == typeId && (joinPositionIndex = label.lastIndexOf(" @")) > uriIndex ? label.substring(uriIndex, joinPositionIndex) : label.substring(uriIndex);
                } else {
                    fullChannel = channel;
                }
                StreamCompositeKey key = new StreamCompositeKey(keyBuffer.getInt(8), keyBuffer.getInt(12), channel);
                StreamPosition position = new StreamPosition(keyBuffer.getLong(0), this.counters.getCounterValue(counterId), typeId);
                ArrayList<StreamPosition> positions = (ArrayList<StreamPosition>)streams.get(key);
                if (null == positions) {
                    positions = new ArrayList<StreamPosition>();
                    streams.put(key, positions);
                }
                positions.add(position);
                String existingFullChannel = (String)fullChannelByStream.get((Object)key);
                if (null == existingFullChannel || fullChannel.length() > existingFullChannel.length()) {
                    fullChannelByStream.put((Object)key, (Object)fullChannel);
                }
            }
        });
        streams.keySet().forEach(k -> {
            k.fullChannel = (String)fullChannelByStream.get(k);
        });
        return streams;
    }

    public int print(PrintStream out) {
        Map<StreamCompositeKey, List<StreamPosition>> streams = this.snapshot();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<StreamCompositeKey, List<StreamPosition>> entry : streams.entrySet()) {
            builder.setLength(0);
            StreamCompositeKey key = entry.getKey();
            builder.append("sessionId=").append(key.sessionId()).append(" streamId=").append(key.streamId()).append(" channel=").append(key.fullChannel).append(" :");
            for (StreamPosition streamPosition : entry.getValue()) {
                builder.append(' ').append(StreamCounter.labelName((int)streamPosition.typeId())).append(':').append(streamPosition.id()).append(':').append(streamPosition.value());
            }
            out.println(builder);
        }
        return streams.size();
    }

    public static final class StreamCompositeKey {
        private final int sessionId;
        private final int streamId;
        private final String channel;
        String fullChannel;

        public StreamCompositeKey(int sessionId, int streamId, String channel) {
            Objects.requireNonNull(channel, "Channel cannot be null");
            this.sessionId = sessionId;
            this.streamId = streamId;
            this.channel = channel;
        }

        public int sessionId() {
            return this.sessionId;
        }

        public int streamId() {
            return this.streamId;
        }

        public String channel() {
            return this.channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreamCompositeKey)) {
                return false;
            }
            StreamCompositeKey that = (StreamCompositeKey)o;
            return this.sessionId == that.sessionId && this.streamId == that.streamId && this.channel.equals(that.channel);
        }

        public int hashCode() {
            int result = this.sessionId;
            result = 31 * result + this.streamId;
            result = 31 * result + this.channel.hashCode();
            return Hashing.hash((int)result);
        }

        public String toString() {
            return "StreamCompositeKey{sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", channel='" + this.channel + "'}";
        }
    }

    public static final class StreamPosition {
        private final long id;
        private final long value;
        private final int typeId;

        public StreamPosition(long id, long value, int typeId) {
            this.id = id;
            this.value = value;
            this.typeId = typeId;
        }

        public long id() {
            return this.id;
        }

        public long value() {
            return this.value;
        }

        public int typeId() {
            return this.typeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StreamPosition)) {
                return false;
            }
            StreamPosition that = (StreamPosition)o;
            return this.id == that.id && this.value == that.value && this.typeId == that.typeId;
        }

        public int hashCode() {
            int result = Hashing.hash((long)this.id);
            result = 31 * result + Hashing.hash((long)this.value);
            result = 31 * result + this.typeId;
            return Hashing.hash((int)result);
        }

        public String toString() {
            return "StreamPosition{id=" + this.id + ", value=" + this.value + ", typeId=" + this.typeId + "}";
        }
    }
}

