/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.echo;

import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.echo.api.EchoMonitorMBean;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

public class EchoPair
implements ControlledFragmentHandler,
AutoCloseable {
    public static final int FRAGMENT_LIMIT = 10;
    private final long correlationId;
    private final Subscription subscription;
    private final Publication publication;
    private long notConnectedCount = 0L;
    private long backPressureCount = 0L;
    private long adminActionCount = 0L;
    private long closedCount = 0L;
    private long maxSessionExceededCount = 0L;
    private long fragmentCount = 0L;
    private long byteCount = 0L;

    public EchoPair(long correlationId, Subscription subscription, Publication publication) {
        this.correlationId = correlationId;
        this.subscription = subscription;
        this.publication = publication;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        long offerPosition = this.publication.offer(buffer, offset, length);
        if (-1L == offerPosition) {
            ++this.notConnectedCount;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (-2L == offerPosition) {
            ++this.backPressureCount;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (-3L == offerPosition) {
            ++this.adminActionCount;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (-4L == offerPosition) {
            ++this.closedCount;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (-5L == offerPosition) {
            ++this.maxSessionExceededCount;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        ++this.fragmentCount;
        this.byteCount += (long)length;
        return ControlledFragmentHandler.Action.COMMIT;
    }

    public int poll() {
        return this.subscription.controlledPoll((ControlledFragmentHandler)this, 10);
    }

    public long correlationId() {
        return this.correlationId;
    }

    public EchoMonitorMBean monitor() {
        return new EchoMonitor();
    }

    @Override
    public void close() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.publication, this.subscription});
    }

    private final class EchoMonitor
    implements EchoMonitorMBean {
        private EchoMonitor() {
        }

        @Override
        public long getCorrelationId() {
            return EchoPair.this.correlationId;
        }

        @Override
        public long getBackPressureCount() {
            return EchoPair.this.backPressureCount;
        }

        @Override
        public long getFragmentCount() {
            return EchoPair.this.fragmentCount;
        }

        @Override
        public long getByteCount() {
            return EchoPair.this.byteCount;
        }
    }
}

