/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import org.HdrHistogram.Histogram;
import org.agrona.SystemUtil;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.SigInt;
import org.agrona.hints.ThreadHints;

public class WriteReceiveUdpPing {
    public static void main(String[] args) throws IOException {
        int numChannels = 1;
        if (1 == args.length) {
            numChannels = Integer.parseInt(args[0]);
        }
        if (SystemUtil.isWindows()) {
            HighResolutionTimer.enable();
        }
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        DatagramChannel[] receiveChannels = new DatagramChannel[numChannels];
        for (int i = 0; i < receiveChannels.length; ++i) {
            receiveChannels[i] = DatagramChannel.open();
            Common.init(receiveChannels[i]);
            receiveChannels[i].bind(new InetSocketAddress("localhost", 20123 + i));
        }
        InetSocketAddress writeAddress = new InetSocketAddress("localhost", 20124);
        DatagramChannel writeChannel = DatagramChannel.open();
        Common.init(writeChannel, writeAddress);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            WriteReceiveUdpPing.measureRoundTrip(histogram, buffer, receiveChannels, writeChannel, running);
            histogram.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    private static void measureRoundTrip(Histogram histogram, ByteBuffer buffer, DatagramChannel[] receiveChannels, DatagramChannel writeChannel, AtomicBoolean running) throws IOException {
        for (int sequenceNumber = 0; sequenceNumber < 10000; ++sequenceNumber) {
            long timestampNs = System.nanoTime();
            buffer.clear();
            buffer.putLong(sequenceNumber);
            buffer.putLong(timestampNs);
            buffer.flip();
            writeChannel.write(buffer);
            buffer.clear();
            boolean available = false;
            block1: while (!available) {
                ThreadHints.onSpinWait();
                if (!running.get()) {
                    return;
                }
                for (int i = receiveChannels.length - 1; i >= 0; --i) {
                    if (null == receiveChannels[i].receive(buffer)) continue;
                    available = true;
                    continue block1;
                }
            }
            long receivedSequenceNumber = buffer.getLong(0);
            if (receivedSequenceNumber != (long)sequenceNumber) {
                throw new IllegalStateException("Data Loss: " + sequenceNumber + " to " + receivedSequenceNumber);
            }
            long durationNs = System.nanoTime() - buffer.getLong(8);
            histogram.recordValue(durationNs);
        }
        histogram.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
    }
}

