/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.samples.ImageRateReporter;
import io.aeron.samples.ImageRateSubscriber;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.SystemUtil;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SigInt;

public class EmbeddedExclusiveBufferClaimIpcThroughput {
    private static final int BURST_LENGTH = 1000000;
    private static final int MESSAGE_LENGTH = SampleConfiguration.MESSAGE_LENGTH;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final String CHANNEL = "aeron:ipc";
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;

    public static void main(String[] args) throws InterruptedException {
        SystemUtil.loadPropertiesFiles((String[])args);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        MediaDriver.Context ctx = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED);
        try (MediaDriver mediaDriver = MediaDriver.launch((MediaDriver.Context)ctx);
             Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(mediaDriver.aeronDirectoryName()));
             Subscription subscription = aeron.addSubscription(CHANNEL, STREAM_ID);
             ExclusivePublication publication = aeron.addExclusivePublication(CHANNEL, STREAM_ID);){
            ImageRateSubscriber subscriber = new ImageRateSubscriber(FRAGMENT_COUNT_LIMIT, running, subscription);
            Thread subscriberThread = new Thread(subscriber);
            subscriberThread.setName("subscriber");
            Thread publisherThread = new Thread(new Publisher(running, (Publication)publication));
            publisherThread.setName("publisher");
            Thread rateReporterThread = new Thread(new ImageRateReporter(MESSAGE_LENGTH, running, subscriber));
            rateReporterThread.setName("rate-reporter");
            rateReporterThread.start();
            subscriberThread.start();
            publisherThread.start();
            subscriberThread.join();
            publisherThread.join();
            rateReporterThread.join();
        }
    }

    static final class Publisher
    implements Runnable {
        private final AtomicBoolean running;
        private final Publication publication;

        Publisher(AtomicBoolean running, Publication publication) {
            this.running = running;
            this.publication = publication;
        }

        @Override
        public void run() {
            IdleStrategy idleStrategy = SampleConfiguration.newIdleStrategy();
            AtomicBoolean running = this.running;
            Publication publication = this.publication;
            BufferClaim bufferClaim = new BufferClaim();
            long backPressureCount = 0L;
            long totalMessageCount = 0L;
            block0: while (running.get()) {
                for (int i = 0; i < 1000000; ++i) {
                    idleStrategy.reset();
                    while (publication.tryClaim(MESSAGE_LENGTH, bufferClaim) <= 0L) {
                        ++backPressureCount;
                        if (!running.get()) break block0;
                        idleStrategy.idle();
                    }
                    int offset = bufferClaim.offset();
                    bufferClaim.buffer().putInt(offset, i);
                    bufferClaim.commit();
                    ++totalMessageCount;
                }
            }
            double backPressureRatio = (double)backPressureCount / (double)totalMessageCount;
            System.out.format("Publisher back pressure ratio: %f%n", backPressureRatio);
        }
    }
}

