/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.DirectBufferVector;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.samples.ImageRateReporter;
import io.aeron.samples.ImageRateSubscriber;
import io.aeron.samples.SampleConfiguration;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.SystemUtil;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.UnsafeBuffer;

public class EmbeddedExclusiveVectoredIpcThroughput {
    private static final int BURST_LENGTH = 1000000;
    private static final int MESSAGE_LENGTH = SampleConfiguration.MESSAGE_LENGTH;
    private static final int VEC_ONE_LENGTH = 16;
    private static final int VEC_TWO_LENGTH = MESSAGE_LENGTH - 16;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final String CHANNEL = "aeron:ipc";
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;

    public static void main(String[] args) throws InterruptedException {
        SystemUtil.loadPropertiesFiles((String[])args);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        MediaDriver.Context ctx = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED);
        try (MediaDriver mediaDriver = MediaDriver.launch((MediaDriver.Context)ctx);
             Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(mediaDriver.aeronDirectoryName()));
             Subscription subscription = aeron.addSubscription(CHANNEL, STREAM_ID);
             ExclusivePublication publication = aeron.addExclusivePublication(CHANNEL, STREAM_ID);){
            ImageRateSubscriber subscriber = new ImageRateSubscriber(FRAGMENT_COUNT_LIMIT, running, subscription);
            Thread subscriberThread = new Thread(subscriber);
            subscriberThread.setName("subscriber");
            Thread publisherThread = new Thread(new Publisher(running, publication));
            publisherThread.setName("publisher");
            Thread rateReporterThread = new Thread(new ImageRateReporter(MESSAGE_LENGTH, running, subscriber));
            rateReporterThread.setName("rate-reporter");
            rateReporterThread.start();
            subscriberThread.start();
            publisherThread.start();
            subscriberThread.join();
            publisherThread.join();
            rateReporterThread.join();
        }
    }

    static final class Publisher
    implements Runnable {
        private final AtomicBoolean running;
        private final ExclusivePublication publication;

        Publisher(AtomicBoolean running, ExclusivePublication publication) {
            this.running = running;
            this.publication = publication;
        }

        @Override
        public void run() {
            IdleStrategy idleStrategy = SampleConfiguration.newIdleStrategy();
            AtomicBoolean running = this.running;
            ExclusivePublication publication = this.publication;
            ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned((int)MESSAGE_LENGTH, (int)64);
            UnsafeBuffer bufferOne = new UnsafeBuffer(byteBuffer, 0, 16);
            UnsafeBuffer bufferTwo = new UnsafeBuffer(byteBuffer, 16, VEC_TWO_LENGTH);
            DirectBufferVector[] vectors = new DirectBufferVector[]{new DirectBufferVector((DirectBuffer)bufferOne, 0, 16), new DirectBufferVector((DirectBuffer)bufferTwo, 0, VEC_TWO_LENGTH)};
            long backPressureCount = 0L;
            long totalMessageCount = 0L;
            block0: while (running.get()) {
                for (int i = 0; i < 1000000; ++i) {
                    idleStrategy.reset();
                    while (publication.offer(vectors, null) <= 0L) {
                        ++backPressureCount;
                        if (!running.get()) break block0;
                        idleStrategy.idle();
                    }
                    ++totalMessageCount;
                }
            }
            double backPressureRatio = (double)backPressureCount / (double)totalMessageCount;
            System.out.format("Publisher back pressure ratio: %f%n", backPressureRatio);
        }
    }
}

