/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.HdrHistogram.Histogram;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.SystemUtil;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpIdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.console.ContinueBarrier;

public class EmbeddedPingPong {
    private static final int PING_STREAM_ID = SampleConfiguration.PING_STREAM_ID;
    private static final int PONG_STREAM_ID = SampleConfiguration.PONG_STREAM_ID;
    private static final long NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final long WARMUP_NUMBER_OF_MESSAGES = SampleConfiguration.WARMUP_NUMBER_OF_MESSAGES;
    private static final int WARMUP_NUMBER_OF_ITERATIONS = SampleConfiguration.WARMUP_NUMBER_OF_ITERATIONS;
    private static final int MESSAGE_LENGTH = SampleConfiguration.MESSAGE_LENGTH;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final int FRAME_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final String PING_CHANNEL = SampleConfiguration.PING_CHANNEL;
    private static final String PONG_CHANNEL = SampleConfiguration.PONG_CHANNEL;
    private static final boolean EXCLUSIVE_PUBLICATIONS = SampleConfiguration.EXCLUSIVE_PUBLICATIONS;
    private static final UnsafeBuffer OFFER_BUFFER = new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)MESSAGE_LENGTH, (int)64));
    private static final Histogram HISTOGRAM = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
    private static final CountDownLatch PONG_IMAGE_LATCH = new CountDownLatch(1);
    private static final IdleStrategy PING_HANDLER_IDLE_STRATEGY = SampleConfiguration.newIdleStrategy();
    private static final IdleStrategy PONG_HANDLER_IDLE_STRATEGY = SampleConfiguration.newIdleStrategy();
    private static final AtomicBoolean RUNNING = new AtomicBoolean(true);

    public static void main(String[] args) throws InterruptedException {
        SystemUtil.loadPropertiesFiles((String[])args);
        MediaDriver.Context ctx = new MediaDriver.Context().threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1000L, 1000L)).receiverIdleStrategy((IdleStrategy)NoOpIdleStrategy.INSTANCE).senderIdleStrategy((IdleStrategy)NoOpIdleStrategy.INSTANCE);
        try (MediaDriver mediaDriver = MediaDriver.launch((MediaDriver.Context)ctx);
             Aeron aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(mediaDriver.aeronDirectoryName()));){
            Thread pongThread = EmbeddedPingPong.startPong(aeron);
            pongThread.start();
            EmbeddedPingPong.runPing(aeron);
            RUNNING.set(false);
            pongThread.join();
            System.out.println("Shutdown Driver...");
        }
    }

    private static void runPing(Aeron aeron) throws InterruptedException {
        System.out.println("Publishing Ping at " + PING_CHANNEL + " on stream id " + PING_STREAM_ID);
        System.out.println("Subscribing Pong at " + PONG_CHANNEL + " on stream id " + PONG_STREAM_ID);
        System.out.println("Message payload length of " + MESSAGE_LENGTH + " bytes");
        System.out.println("Using exclusive publications: " + EXCLUSIVE_PUBLICATIONS);
        FragmentAssembler dataHandler = new FragmentAssembler(EmbeddedPingPong::pongHandler);
        try (Subscription pongSubscription = aeron.addSubscription(PONG_CHANNEL, PONG_STREAM_ID, EmbeddedPingPong::availablePongImageHandler, null);
             ExclusivePublication pingPublication = EXCLUSIVE_PUBLICATIONS ? aeron.addExclusivePublication(PING_CHANNEL, PING_STREAM_ID) : aeron.addPublication(PING_CHANNEL, PING_STREAM_ID);){
            System.out.println("Waiting for new image from Pong...");
            PONG_IMAGE_LATCH.await();
            System.out.format("Warming up... %d iterations of %,d messages%n", WARMUP_NUMBER_OF_ITERATIONS, WARMUP_NUMBER_OF_MESSAGES);
            for (int i = 0; i < WARMUP_NUMBER_OF_ITERATIONS; ++i) {
                EmbeddedPingPong.roundTripMessages((FragmentHandler)dataHandler, (Publication)pingPublication, pongSubscription, WARMUP_NUMBER_OF_MESSAGES);
                Thread.yield();
            }
            Thread.sleep(100L);
            ContinueBarrier barrier = new ContinueBarrier("Execute again?");
            do {
                HISTOGRAM.reset();
                System.out.format("Pinging %,d messages%n", NUMBER_OF_MESSAGES);
                EmbeddedPingPong.roundTripMessages((FragmentHandler)dataHandler, (Publication)pingPublication, pongSubscription, NUMBER_OF_MESSAGES);
                System.out.println("Histogram of RTT latencies in microseconds.");
                HISTOGRAM.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
            } while (barrier.await());
        }
    }

    private static Thread startPong(Aeron aeron) {
        return new Thread(() -> {
            System.out.println("Subscribing Ping at " + PING_CHANNEL + " on stream id " + PING_STREAM_ID);
            System.out.println("Publishing Pong at " + PONG_CHANNEL + " on stream id " + PONG_STREAM_ID);
            try (Subscription pingSubscription = aeron.addSubscription(PING_CHANNEL, PING_STREAM_ID);
                 ExclusivePublication pongPublication = EXCLUSIVE_PUBLICATIONS ? aeron.addExclusivePublication(PONG_CHANNEL, PONG_STREAM_ID) : aeron.addPublication(PONG_CHANNEL, PONG_STREAM_ID);){
                BufferClaim bufferClaim = new BufferClaim();
                FragmentHandler fragmentHandler = (arg_0, arg_1, arg_2, arg_3) -> EmbeddedPingPong.lambda$startPong$0(bufferClaim, (Publication)pongPublication, arg_0, arg_1, arg_2, arg_3);
                while (RUNNING.get()) {
                    PING_HANDLER_IDLE_STRATEGY.idle(pingSubscription.poll(fragmentHandler, FRAME_COUNT_LIMIT));
                }
                System.out.println("Shutting down...");
            }
        });
    }

    private static void roundTripMessages(FragmentHandler fragmentHandler, Publication pingPublication, Subscription pongSubscription, long numMessages) {
        while (!pongSubscription.isConnected()) {
            Thread.yield();
        }
        Image image = pongSubscription.imageAtIndex(0);
        for (long i = 0L; i < numMessages; ++i) {
            long offeredPosition;
            do {
                OFFER_BUFFER.putLong(0, System.nanoTime());
            } while ((offeredPosition = pingPublication.offer((DirectBuffer)OFFER_BUFFER, 0, MESSAGE_LENGTH, null)) < 0L);
            while (image.position() < offeredPosition) {
                int fragments = image.poll(fragmentHandler, FRAGMENT_COUNT_LIMIT);
                PONG_HANDLER_IDLE_STRATEGY.idle(fragments);
            }
        }
    }

    private static void pongHandler(DirectBuffer buffer, int offset, int length, Header header) {
        long pingTimestamp = buffer.getLong(offset);
        long rttNs = System.nanoTime() - pingTimestamp;
        HISTOGRAM.recordValue(rttNs);
    }

    private static void availablePongImageHandler(Image image) {
        Subscription subscription = image.subscription();
        if (PONG_STREAM_ID == subscription.streamId() && PONG_CHANNEL.equals(subscription.channel())) {
            PONG_IMAGE_LATCH.countDown();
        }
    }

    static void pingHandler(BufferClaim bufferClaim, Publication pongPublication, DirectBuffer buffer, int offset, int length, Header header) {
        PING_HANDLER_IDLE_STRATEGY.reset();
        while (pongPublication.tryClaim(length, bufferClaim) <= 0L) {
            PING_HANDLER_IDLE_STRATEGY.idle();
        }
        bufferClaim.flags(header.flags()).putBytes(buffer, offset, length).commit();
    }

    private static /* synthetic */ void lambda$startPong$0(BufferClaim bufferClaim, Publication pongPublication, DirectBuffer buffer, int offset, int length, Header header) {
        EmbeddedPingPong.pingHandler(bufferClaim, pongPublication, buffer, offset, length, header);
    }
}

