/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.samples.RateReporter;
import io.aeron.samples.SampleConfiguration;
import io.aeron.samples.SamplesUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.CloseHelper;
import org.agrona.concurrent.SigInt;

public class RateSubscriber {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        System.out.println("Subscribing to " + CHANNEL + " on stream id " + STREAM_ID);
        MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Aeron.Context ctx = new Aeron.Context().availableImageHandler(SamplesUtil::printAvailableImage).unavailableImageHandler(SamplesUtil::printUnavailableImage);
        if (EMBEDDED_MEDIA_DRIVER) {
            ctx.aeronDirectoryName(driver.aeronDirectoryName());
        }
        RateReporter reporter = new RateReporter(TimeUnit.SECONDS.toNanos(1L), SamplesUtil::printRate);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> {
            reporter.halt();
            running.set(false);
        });
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             Subscription subscription = aeron.addSubscription(CHANNEL, STREAM_ID);){
            Future<?> future = executor.submit(() -> SamplesUtil.subscriberLoop(SamplesUtil.rateReporterHandler(reporter), FRAGMENT_COUNT_LIMIT, running).accept(subscription));
            reporter.run();
            System.out.println("Shutting down...");
            future.get();
        }
        executor.shutdown();
        if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
            System.out.println("Warning: not all tasks completed promptly");
        }
        CloseHelper.close((AutoCloseable)driver);
    }
}

