/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.ConcurrentPublication;
import java.util.concurrent.TimeUnit;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SimplePublisher {
    public static void main(String[] args) throws InterruptedException {
        UnsafeBuffer buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)512, (int)64));
        String channel = "aeron:udp?endpoint=localhost:40123";
        int streamId = 10;
        System.out.println("Publishing to aeron:udp?endpoint=localhost:40123 on stream id 10");
        Aeron.Context ctx = new Aeron.Context();
        try (Aeron aeron = Aeron.connect((Aeron.Context)ctx);
             ConcurrentPublication publication = aeron.addPublication("aeron:udp?endpoint=localhost:40123", 10);){
            String message = "Hello World! ";
            byte[] messageBytes = "Hello World! ".getBytes();
            buffer.putBytes(0, messageBytes);
            long deadlineNs = System.nanoTime() + TimeUnit.SECONDS.toNanos(5L);
            while (!publication.isConnected()) {
                if (deadlineNs - System.nanoTime() < 0L) {
                    System.out.println("Failed to connect to subscriber");
                    return;
                }
                Thread.sleep(1L);
            }
            long position = publication.offer((DirectBuffer)buffer, 0, messageBytes.length);
            if (position < 0L) {
                if (position == -2L) {
                    System.out.println(" Offer failed due to back pressure");
                } else if (position == -1L) {
                    System.out.println(" Offer failed because publisher is not connected to subscriber");
                } else if (position == -3L) {
                    System.out.println("Offer failed because of an administration action in the system");
                } else if (position == -4L) {
                    System.out.println("Offer failed publication is closed");
                } else if (position == -5L) {
                    System.out.println("Offer failed due to publication reaching max position");
                } else {
                    System.out.println(" Offer failed due to unknown reason");
                }
            } else {
                System.out.println(" yay !!");
            }
            System.out.println("Done sending.");
        }
    }
}

