/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.ConcurrentPublication;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.YieldingIdleStrategy;
import org.agrona.concurrent.status.CountersReader;

public class RecordedBasicPublisher {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final long NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final UnsafeBuffer BUFFER = new UnsafeBuffer(BufferUtil.allocateDirectAligned((int)256, (int)64));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        System.out.println("Publishing to " + CHANNEL + " on stream id " + STREAM_ID);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        AeronArchive.Context archiveCtx = new AeronArchive.Context().controlResponseStreamId(AeronArchive.Configuration.controlResponseStreamId() + 1);
        try (AeronArchive archive = AeronArchive.connect((AeronArchive.Context)archiveCtx);){
            archive.startRecording(CHANNEL, STREAM_ID, SourceLocation.LOCAL);
            try (ConcurrentPublication publication = archive.context().aeron().addPublication(CHANNEL, STREAM_ID);){
                YieldingIdleStrategy idleStrategy = YieldingIdleStrategy.INSTANCE;
                CountersReader counters = archive.context().aeron().countersReader();
                long archiveId = archive.archiveId();
                int counterId = RecordingPos.findCounterIdBySession((CountersReader)counters, (int)publication.sessionId(), (long)archiveId);
                while (-1 == counterId) {
                    if (!running.get()) {
                        return;
                    }
                    idleStrategy.idle();
                    counterId = RecordingPos.findCounterIdBySession((CountersReader)counters, (int)publication.sessionId(), (long)archiveId);
                }
                long recordingId = RecordingPos.getRecordingId((CountersReader)counters, (int)counterId);
                System.out.println("Recording started: recordingId = " + recordingId);
                for (long i = 0L; i < NUMBER_OF_MESSAGES && running.get(); ++i) {
                    String message = "Hello World! " + i;
                    byte[] messageBytes = message.getBytes();
                    BUFFER.putBytes(0, messageBytes);
                    System.out.print("Offering " + i + "/" + NUMBER_OF_MESSAGES + " - ");
                    long position = publication.offer((DirectBuffer)BUFFER, 0, messageBytes.length);
                    RecordedBasicPublisher.checkResult(position);
                    String errorMessage = archive.pollForErrorResponse();
                    if (null != errorMessage) {
                        throw new IllegalStateException(errorMessage);
                    }
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                idleStrategy.reset();
                while (counters.getCounterValue(counterId) < publication.position()) {
                    if (!RecordingPos.isActive((CountersReader)counters, (int)counterId, (long)recordingId)) {
                        throw new IllegalStateException("recording has stopped unexpectedly: " + recordingId);
                    }
                    idleStrategy.idle();
                }
            }
            finally {
                System.out.println("Done sending.");
                archive.stopRecording(CHANNEL, STREAM_ID);
            }
        }
    }

    private static void checkResult(long position) {
        if (position > 0L) {
            System.out.println("yay!");
        } else if (position == -2L) {
            System.out.println("Offer failed due to back pressure");
        } else if (position == -3L) {
            System.out.println("Offer failed because of an administration action in the system");
        } else if (position == -1L) {
            System.out.println("Offer failed because publisher is not connected to subscriber");
        } else if (position == -4L) {
            System.out.println("Offer failed publication is closed");
        } else {
            if (position == -5L) {
                throw new IllegalStateException("Offer failed due to publication reaching max position");
            }
            System.out.println("Offer failed due to unknown result code: " + position);
        }
    }
}

