/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster;

import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.Cluster;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.IdleStrategy;

class EchoService
implements ClusteredService {
    private static final int SEND_ATTEMPTS = 3;
    protected Cluster cluster;
    protected IdleStrategy idleStrategy;

    EchoService() {
    }

    public void onStart(Cluster cluster, Image snapshotImage) {
        this.cluster = cluster;
        this.idleStrategy = cluster.idleStrategy();
    }

    public void onSessionOpen(ClientSession session, long timestamp) {
    }

    public void onSessionClose(ClientSession session, long timestamp, CloseReason closeReason) {
    }

    public void onSessionMessage(ClientSession session, long timestamp, DirectBuffer buffer, int offset, int length, Header header) {
        this.idleStrategy.reset();
        int attempts = 3;
        do {
            long result;
            if ((result = session.offer(buffer, offset, length)) > 0L) {
                return;
            }
            this.idleStrategy.idle();
        } while (--attempts > 0);
    }

    public void onTimerEvent(long correlationId, long timestamp) {
    }

    public void onTakeSnapshot(ExclusivePublication snapshotPublication) {
    }

    public void onRoleChange(Cluster.Role newRole) {
    }

    public void onTerminate(Cluster cluster) {
    }
}

