/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.echo;

import io.aeron.Aeron;
import io.aeron.ConcurrentPublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.samples.echo.CreateEchoPair;
import io.aeron.samples.echo.EchoPair;
import io.aeron.samples.echo.ProvisioningMessage;
import io.aeron.samples.echo.RemoveAllEchoPairs;
import io.aeron.samples.echo.api.EchoMonitorMBean;
import io.aeron.samples.echo.api.ProvisioningConstants;
import io.aeron.samples.echo.api.ProvisioningMBean;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.agrona.CloseHelper;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;

public class Provisioning
implements ProvisioningMBean {
    private final Aeron aeron;
    private final Long2ObjectHashMap<EchoPair> echoPairByCorrelationId = new Long2ObjectHashMap();
    private final ManyToOneConcurrentArrayQueue<ProvisioningMessage> provisioningMessageQ = new ManyToOneConcurrentArrayQueue(1024);

    public Provisioning(Aeron aeron) {
        this.aeron = aeron;
    }

    public int doWork() {
        int workDone = 0;
        workDone += this.pollProvisioningQueue();
        return workDone += this.pollEchoPairs();
    }

    @Override
    public void removeAll() {
        RemoveAllEchoPairs removeAllEchoPairs = new RemoveAllEchoPairs();
        this.provisioningMessageQ.add((Object)removeAllEchoPairs);
        try {
            removeAllEchoPairs.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void createEchoPair(long correlationId, String subChannel, int subStreamId, String pubChannel, int pubStreamId) {
        CreateEchoPair createEchoPair = new CreateEchoPair(correlationId, subChannel, subStreamId, pubChannel, pubStreamId);
        this.provisioningMessageQ.add((Object)createEchoPair);
        try {
            createEchoPair.await();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void handleCreateEchoPair(CreateEchoPair create) throws Exception {
        Subscription subscription;
        ConcurrentPublication publication = this.aeron.addPublication(create.publicationChannel, create.publicationStream);
        try {
            subscription = this.aeron.addSubscription(create.subscriptionChannel, create.subscriptionStream);
        }
        catch (Exception ex) {
            CloseHelper.quietClose((AutoCloseable)publication);
            throw ex;
        }
        EchoPair echoPair = new EchoPair(create.correlationId, subscription, (Publication)publication);
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(new StandardMBean(echoPair.monitor(), EchoMonitorMBean.class), new ObjectName(ProvisioningConstants.echoPairObjectName(create.correlationId)));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException ex) {
            CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{subscription, publication});
            throw ex;
        }
        this.echoPairByCorrelationId.put(echoPair.correlationId(), (Object)echoPair);
    }

    private int pollEchoPairs() {
        int workDone = 0;
        for (EchoPair echoPair : this.echoPairByCorrelationId.values()) {
            workDone += echoPair.poll();
        }
        return workDone;
    }

    private int pollProvisioningQueue() {
        ProvisioningMessage poll;
        int workDone = 0;
        while (null != (poll = (ProvisioningMessage)this.provisioningMessageQ.poll())) {
            ++workDone;
            try {
                if (poll instanceof CreateEchoPair) {
                    this.handleCreateEchoPair((CreateEchoPair)poll);
                } else if (poll instanceof RemoveAllEchoPairs) {
                    this.handleRemoveAll();
                }
                poll.complete("OK");
            }
            catch (Exception ex) {
                poll.complete(ex);
            }
        }
        return workDone;
    }

    private void handleRemoveAll() {
        for (EchoPair echoPair : this.echoPairByCorrelationId.values()) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(ProvisioningConstants.echoPairObjectName(echoPair.correlationId())));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            catch (MBeanRegistrationException | MalformedObjectNameException ex) {
                ex.printStackTrace();
            }
            CloseHelper.quietClose((AutoCloseable)echoPair);
        }
        this.echoPairByCorrelationId.clear();
    }
}

