/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.raw;

import io.aeron.samples.raw.Common;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import java.util.function.IntSupplier;
import org.HdrHistogram.Histogram;
import org.agrona.SystemUtil;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.SigInt;

public class SendSelectReceiveUdpPing {
    public static void main(String[] args) throws IOException {
        if (SystemUtil.isWindows()) {
            HighResolutionTimer.enable();
        }
        Histogram histogram = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1408);
        DatagramChannel receiveChannel = DatagramChannel.open();
        Common.init(receiveChannel);
        receiveChannel.bind(new InetSocketAddress("localhost", 20123));
        InetSocketAddress sendAddress = new InetSocketAddress("localhost", 20124);
        DatagramChannel sendChannel = DatagramChannel.open();
        Common.init(sendChannel);
        Selector selector = Selector.open();
        MutableLong sequence = new MutableLong();
        IntSupplier handler = () -> {
            try {
                buffer.clear();
                receiveChannel.receive(buffer);
                long receivedSequenceNumber = buffer.getLong(0);
                long receivedTimestampNs = buffer.getLong(8);
                if (receivedSequenceNumber != sequence.get()) {
                    throw new IllegalStateException("Data Loss: " + sequence + " to " + receivedSequenceNumber);
                }
                long durationNs = System.nanoTime() - receivedTimestampNs;
                histogram.recordValue(durationNs);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 1;
        };
        receiveChannel.register(selector, 1, handler);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            SendSelectReceiveUdpPing.measureRoundTrip(histogram, sendAddress, buffer, sendChannel, selector, sequence, running);
            histogram.reset();
            System.gc();
            LockSupport.parkNanos(1000000000L);
        }
    }

    private static void measureRoundTrip(Histogram histogram, InetSocketAddress sendAddress, ByteBuffer buffer, DatagramChannel sendChannel, Selector selector, MutableLong sequence, AtomicBoolean running) throws IOException {
        for (int i = 0; i < 10000; ++i) {
            sequence.set((long)i);
            long timestamp = System.nanoTime();
            buffer.clear();
            buffer.putLong(i);
            buffer.putLong(timestamp);
            buffer.flip();
            sendChannel.send(buffer, sendAddress);
            while (selector.selectNow() == 0) {
                if (!running.get()) {
                    return;
                }
                Thread.onSpinWait();
            }
            Set<SelectionKey> selectedKeys = selector.selectedKeys();
            Iterator<SelectionKey> iter = selectedKeys.iterator();
            while (iter.hasNext()) {
                SelectionKey key = iter.next();
                if (key.isReadable()) {
                    ((IntSupplier)key.attachment()).getAsInt();
                }
                iter.remove();
            }
        }
        histogram.outputPercentileDistribution(System.out, Double.valueOf(1000.0));
    }
}

