/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.stress;

import java.util.concurrent.CountDownLatch;
import org.agrona.CloseHelper;

class ShutdownBarrier {
    private final AutoCloseable closeable;
    private final CountDownLatch startCloseLatch = new CountDownLatch(1);
    private final CountDownLatch completeCloseLatch = new CountDownLatch(1);

    ShutdownBarrier(AutoCloseable closeable) {
        this.closeable = closeable;
        Runtime.getRuntime().addShutdownHook(new Thread(this::signal, "shutdown-thread"));
    }

    private void signal() {
        this.startCloseLatch.countDown();
        try {
            this.completeCloseLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void run() throws InterruptedException {
        try {
            this.startCloseLatch.await();
        }
        finally {
            CloseHelper.quietClose((AutoCloseable)this.closeable);
            this.completeCloseLatch.countDown();
        }
    }

    public static void awaitAndCloseOnExit(AutoCloseable closeable) throws InterruptedException {
        new ShutdownBarrier(closeable).run();
    }
}

