/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.stress;

import io.aeron.Aeron;
import io.aeron.ControlledFragmentAssembler;
import io.aeron.Counter;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.stress.CRC64;
import io.aeron.samples.stress.SimpleReservedValueSupplier;
import io.aeron.samples.stress.StressUtil;
import java.util.concurrent.locks.LockSupport;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.Agent;

public class StressMdcServer
implements Agent {
    private final String serverAddress;
    private final String clientAddress;
    private final ControlledFragmentAssembler mdcFragmentAssembler1 = new ControlledFragmentAssembler(this::mdcReqHandler);
    private final ControlledFragmentAssembler mdcFragmentAssembler2 = new ControlledFragmentAssembler(this::mdcReqHandler);
    private final SimpleReservedValueSupplier valueSupplier = new SimpleReservedValueSupplier();
    private final CRC64 crc = new CRC64();
    private Aeron aeron;
    private Subscription mdcSubscription1;
    private Subscription mdcSubscription2;
    private Publication mdcPublication;
    private Counter serverReceiveCount;
    private Counter serverSendCount;

    public StressMdcServer(String serverAddress, String clientAddress) {
        this.serverAddress = serverAddress;
        this.clientAddress = clientAddress;
    }

    public void onStart() {
        this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context());
        this.mdcSubscription1 = this.aeron.addSubscription(StressUtil.mdcReqSubChannel1(this.serverAddress, this.clientAddress).build(), 10002, StressUtil::imageAvailable, StressUtil::imageUnavailable);
        this.mdcSubscription2 = this.aeron.addSubscription(StressUtil.mdcReqSubChannel2(this.serverAddress, this.clientAddress).build(), 10002, StressUtil::imageAvailable, StressUtil::imageUnavailable);
        this.mdcPublication = this.aeron.addPublication(StressUtil.mdcRspPubChannel(this.serverAddress).linger(Long.valueOf(0L)).build(), 10002);
        this.serverReceiveCount = this.aeron.addCounter(1000, "Server Receive Count");
        this.serverSendCount = this.aeron.addCounter(1001, "Server Send Count");
    }

    public int doWork() {
        if (!this.mdcSubscription1.isConnected() || !this.mdcSubscription2.isConnected()) {
            return 0;
        }
        int count = 0;
        return count += this.pollUnicast();
    }

    private int pollUnicast() {
        int count = 0;
        count += this.mdcSubscription1.controlledPoll((ControlledFragmentHandler)this.mdcFragmentAssembler1, 1);
        return count += this.mdcSubscription2.controlledPoll((ControlledFragmentHandler)this.mdcFragmentAssembler2, 1);
    }

    private ControlledFragmentHandler.Action mdcReqHandler(DirectBuffer msg, int offset, int length, Header header) {
        long correlationId = header.reservedValue();
        StressUtil.validateMessage(this.crc, msg, offset, length, correlationId);
        long result = this.mdcPublication.offer(msg, offset, length, this.valueSupplier.set(correlationId));
        if (result > 0L) {
            this.serverReceiveCount.increment();
            this.serverSendCount.increment();
        }
        return result < 0L ? ControlledFragmentHandler.Action.ABORT : ControlledFragmentHandler.Action.COMMIT;
    }

    public String roleName() {
        return "Stress MDC Server";
    }

    public void onClose() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.mdcSubscription1, this.mdcSubscription2, this.mdcPublication, this.aeron});
        LockSupport.parkNanos(1000000000L);
    }

    public static void main(String[] args) {
        StressMdcServer server = new StressMdcServer(StressUtil.serverAddress(), StressUtil.clientAddress());
        server.onStart();
        try {
            while (!Thread.currentThread().isInterrupted()) {
                server.doWork();
            }
        }
        finally {
            server.onClose();
        }
    }
}

