/*
 * Decompiled with CFR 0.152.
 */
package io.agora.media;

import io.agora.media.AccessToken;

public class RtcTokenBuilder {
    public String buildTokenWithUid(String appId, String appCertificate, String channelName, int uid, Role role, int privilegeTs) {
        String account = uid == 0 ? "" : String.valueOf(uid);
        return this.buildTokenWithUserAccount(appId, appCertificate, channelName, account, role, privilegeTs);
    }

    public String buildTokenWithUserAccount(String appId, String appCertificate, String channelName, String account, Role role, int privilegeTs) {
        AccessToken builder = new AccessToken(appId, appCertificate, channelName, account);
        builder.addPrivilege(AccessToken.Privileges.kJoinChannel, privilegeTs);
        if (role == Role.Role_Publisher || role == Role.Role_Subscriber || role == Role.Role_Admin) {
            builder.addPrivilege(AccessToken.Privileges.kPublishAudioStream, privilegeTs);
            builder.addPrivilege(AccessToken.Privileges.kPublishVideoStream, privilegeTs);
            builder.addPrivilege(AccessToken.Privileges.kPublishDataStream, privilegeTs);
        }
        try {
            return builder.build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static enum Role {
        Role_Attendee(0),
        Role_Publisher(1),
        Role_Subscriber(2),
        Role_Admin(101);

        public int initValue;

        private Role(int initValue) {
            this.initValue = initValue;
        }
    }
}

