/*
 * Decompiled with CFR 0.152.
 */
package io.agora.base.internal.video;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.agora.base.TextureBuffer;
import io.agora.base.VideoFrame;
import io.agora.base.internal.Logging;
import io.agora.base.internal.ThreadUtils;
import io.agora.base.internal.video.EglBase;
import io.agora.base.internal.video.EglBaseFactory;
import io.agora.base.internal.video.GlUtil;
import io.agora.base.internal.video.ISurfaceTextureHelper;
import io.agora.base.internal.video.RendererCommon;
import io.agora.base.internal.video.TextureBufferPool;
import io.agora.base.internal.video.VideoDecimator;
import io.agora.base.internal.video.VideoSink;
import io.agora.base.internal.video.YuvConverter;
import java.util.concurrent.Callable;

public class TimerSurfaceTextureHelper
implements ISurfaceTextureHelper {
    private static final String TAG = "TSurfaceTextureHelper";
    private final Handler delayHandler;
    private final VideoDecimator videoDecimator;
    private volatile int notifyIntervalInMS = 0;
    private static final int DEFAULT_MAX_BUFFER_COUNT = 4;
    private final Handler handler;
    private final EglBase eglBase;
    @NonNull
    private final EglBase.Context sharedContext;
    private final SurfaceTexture surfaceTexture;
    private final int oesTextureId;
    private final YuvConverter yuvConverter = new YuvConverter();
    private final TextureBufferPool textureBufferPool;
    @Nullable
    private VideoSink listener;
    private boolean hasPendingTexture = false;
    private volatile boolean isOesTextureInUse = false;
    private boolean isQuitting = false;
    private int frameRotation;
    private int textureWidth;
    private int textureHeight;
    @Nullable
    private VideoSink pendingListener;
    final Runnable setListenerRunnable = new Runnable(){

        @Override
        public void run() {
            Logging.d(TimerSurfaceTextureHelper.TAG, "Setting listener to " + TimerSurfaceTextureHelper.this.pendingListener);
            TimerSurfaceTextureHelper.this.listener = TimerSurfaceTextureHelper.this.pendingListener;
            TimerSurfaceTextureHelper.this.pendingListener = null;
            if (TimerSurfaceTextureHelper.this.hasPendingTexture) {
                TimerSurfaceTextureHelper.this.updateTexImage();
                TimerSurfaceTextureHelper.this.hasPendingTexture = false;
            }
            TimerSurfaceTextureHelper.this.delayHandler.postDelayed(TimerSurfaceTextureHelper.this.delayNotifyRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
        }
    };
    final Runnable timerNotifyRunnable = new Runnable(){

        @Override
        public void run() {
            TimerSurfaceTextureHelper.this.tryDeliverTextureFrame();
        }
    };
    final Runnable delayNotifyRunnable = new Runnable(){

        @Override
        public void run() {
            TimerSurfaceTextureHelper.this.videoDecimator.updateIncomingFramerate();
            if (TimerSurfaceTextureHelper.this.videoDecimator.dropFrame()) {
                Logging.d(TimerSurfaceTextureHelper.TAG, "videoDecimator  dropFrame.");
            } else {
                TimerSurfaceTextureHelper.this.handler.post(TimerSurfaceTextureHelper.this.timerNotifyRunnable);
            }
            TimerSurfaceTextureHelper.this.delayHandler.removeCallbacks(TimerSurfaceTextureHelper.this.delayNotifyRunnable);
            TimerSurfaceTextureHelper.this.delayHandler.postDelayed(TimerSurfaceTextureHelper.this.delayNotifyRunnable, (long)TimerSurfaceTextureHelper.this.notifyIntervalInMS);
        }
    };
    private static final int ANDROID_API_TEXTURE_IN_USE = 10;

    @Nullable
    public static TimerSurfaceTextureHelper create(String threadName, EglBase.Context sharedContext) {
        return TimerSurfaceTextureHelper.create(threadName, sharedContext, 4);
    }

    @Nullable
    public static TimerSurfaceTextureHelper create(final String threadName, final EglBase.Context sharedContext, final int maxBufCount) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        final Handler handler = new Handler(thread.getLooper());
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(handler, new Callable<TimerSurfaceTextureHelper>(){

                @Override
                @Nullable
                public TimerSurfaceTextureHelper call() {
                    try {
                        return new TimerSurfaceTextureHelper(threadName, sharedContext, handler, maxBufCount);
                    }
                    catch (RuntimeException e) {
                        Logging.e(TimerSurfaceTextureHelper.TAG, threadName + " create failure", e);
                        return null;
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.e(TAG, threadName + " create failure", e);
            return null;
        }
    }

    private TimerSurfaceTextureHelper(String name, EglBase.Context sharedContext, Handler handler, int maxBufCount) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("SurfaceTextureHelper must be created on the handler thread");
        }
        this.handler = handler;
        HandlerThread delayThread = new HandlerThread("delayThread");
        delayThread.start();
        this.delayHandler = new Handler(delayThread.getLooper());
        this.eglBase = EglBaseFactory.create(sharedContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            this.delayHandler.getLooper().quit();
            throw e;
        }
        this.videoDecimator = new VideoDecimator();
        this.sharedContext = sharedContext != null ? sharedContext : this.eglBase.getEglBaseContext();
        this.oesTextureId = GlUtil.generateTexture(36197);
        this.surfaceTexture = new SurfaceTexture(this.oesTextureId);
        this.textureBufferPool = TextureBufferPool.createWithinGlThread(name, maxBufCount, 6407, handler, this.eglBase, this.yuvConverter);
        TimerSurfaceTextureHelper.setOnFrameAvailableListener(this.surfaceTexture, new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture st) {
                TimerSurfaceTextureHelper.this.hasPendingTexture = true;
                TimerSurfaceTextureHelper.this.delayHandler.post(TimerSurfaceTextureHelper.this.delayNotifyRunnable);
            }
        }, handler);
    }

    @TargetApi(value=21)
    private static void setOnFrameAvailableListener(SurfaceTexture surfaceTexture, SurfaceTexture.OnFrameAvailableListener listener, Handler handler) {
        if (Build.VERSION.SDK_INT >= 21) {
            surfaceTexture.setOnFrameAvailableListener(listener, handler);
        } else {
            surfaceTexture.setOnFrameAvailableListener(listener);
        }
    }

    public void setFrameRate(int frameRate) {
        if (frameRate <= 0) {
            throw new IllegalArgumentException("invalid frame rate");
        }
        int minRate = frameRate;
        if (frameRate >= 5) {
            minRate = 5;
        }
        if (frameRate >= 15) {
            minRate = 15;
        }
        if (frameRate >= 30) {
            minRate = 30;
        }
        this.notifyIntervalInMS = 1000 / minRate;
        if (null != this.videoDecimator) {
            this.videoDecimator.setTargetFramerate(frameRate);
        }
    }

    @Override
    public void startListening(VideoSink listener) {
        if (this.listener != null || this.pendingListener != null) {
            throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
        }
        if (this.notifyIntervalInMS == 0) {
            throw new IllegalStateException("frame rate not set");
        }
        this.pendingListener = listener;
        this.handler.post(this.setListenerRunnable);
    }

    @Nullable
    public VideoFrame.TextureBuffer textureCopy(final VideoFrame.TextureBuffer textureBuffer) {
        if (textureBuffer.getTextureId() != this.oesTextureId) {
            throw new IllegalStateException("textureCopy called with unexpected textureId");
        }
        try {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Callable<VideoFrame.TextureBuffer>(){

                @Override
                public VideoFrame.TextureBuffer call() {
                    return TimerSurfaceTextureHelper.this.textureBufferPool.textureCopy(textureBuffer, new Runnable(){

                        @Override
                        public void run() {
                            TimerSurfaceTextureHelper.this.handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    if (TimerSurfaceTextureHelper.this.isQuitting && !TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                                        TimerSurfaceTextureHelper.this.release();
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Logging.d(TAG, "textureCopy  fail: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void stopListening() {
        Logging.d(TAG, "stopListening()");
        this.delayHandler.removeCallbacks(this.delayNotifyRunnable);
        this.handler.removeCallbacks(this.setListenerRunnable);
        this.videoDecimator.reset();
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    TimerSurfaceTextureHelper.this.listener = null;
                    TimerSurfaceTextureHelper.this.pendingListener = null;
                }
            });
        }
        catch (Exception e) {
            Logging.d(TAG, "stopListening faile: " + e.getMessage());
        }
    }

    @Override
    public void setTextureSize(final int textureWidth, final int textureHeight) {
        if (textureWidth <= 0) {
            throw new IllegalArgumentException("Texture width must be positive, but was " + textureWidth);
        }
        if (textureHeight <= 0) {
            throw new IllegalArgumentException("Texture height must be positive, but was " + textureHeight);
        }
        Logging.d(TAG, "setTextureSize textureWidth: " + textureWidth + " textureHeight: " + textureHeight);
        this.surfaceTexture.setDefaultBufferSize(textureWidth, textureHeight);
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.textureWidth = textureWidth;
                TimerSurfaceTextureHelper.this.textureHeight = textureHeight;
            }
        });
    }

    @Override
    public void setFrameRotation(final int rotation) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.frameRotation = rotation;
            }
        });
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.surfaceTexture;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    private void returnTextureFrame() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.isOesTextureInUse = false;
                if (TimerSurfaceTextureHelper.this.isQuitting && !TimerSurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                    TimerSurfaceTextureHelper.this.release();
                }
            }
        });
    }

    @Override
    public boolean isOesTextureInUse() {
        return this.isOesTextureInUse;
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose()");
        try {
            ThreadUtils.invokeAtFrontUninterruptibly(this.handler, new Runnable(){

                @Override
                public void run() {
                    TimerSurfaceTextureHelper.this.isQuitting = true;
                    if (!TimerSurfaceTextureHelper.this.isOesTextureInUse && !TimerSurfaceTextureHelper.this.textureBufferPool.anyTextureInUse()) {
                        TimerSurfaceTextureHelper.this.release();
                    } else {
                        Logging.d(TimerSurfaceTextureHelper.TAG, " not release yet, this: " + this + " isOesTextureInUse: " + TimerSurfaceTextureHelper.this.isOesTextureInUse);
                    }
                }
            });
        }
        catch (Exception e) {
            Logging.d(TAG, "dispose fail: " + e.getMessage());
        }
    }

    @Deprecated
    public VideoFrame.I420Buffer textureToYuv(VideoFrame.TextureBuffer textureBuffer) {
        return textureBuffer.toI420();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTexImage() {
        try {
            Object object = EglBase.lock;
            synchronized (object) {
                this.surfaceTexture.updateTexImage();
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "failed to updateTexImage. " + e.getMessage());
        }
    }

    private boolean tryDeliverTextureFrame() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isQuitting || this.listener == null) {
            return false;
        }
        if (this.isOesTextureInUse) {
            if (this.listener instanceof IVideoCapture) {
                ((IVideoCapture)this.listener).onFrameDropped(10);
            }
            Logging.d(TAG, "frame Dropped texture in use. ");
            return true;
        }
        this.isOesTextureInUse = true;
        this.hasPendingTexture = false;
        this.updateTexImage();
        float[] transformMatrix = new float[16];
        this.surfaceTexture.getTransformMatrix(transformMatrix);
        long timestampNs = this.surfaceTexture.getTimestamp();
        if (this.textureWidth == 0 || this.textureHeight == 0) {
            throw new RuntimeException("Texture size has not been set.");
        }
        TextureBuffer buffer = new TextureBuffer(this.sharedContext, this.textureWidth, this.textureHeight, VideoFrame.TextureBuffer.Type.OES, this.oesTextureId, RendererCommon.convertMatrixToAndroidGraphicsMatrix(transformMatrix), this.handler, this.yuvConverter, new Runnable(){

            @Override
            public void run() {
                TimerSurfaceTextureHelper.this.returnTextureFrame();
            }
        });
        VideoFrame frame = new VideoFrame(buffer, this.frameRotation, timestampNs);
        this.listener.onFrame(frame);
        frame.release();
        return true;
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        if (this.isOesTextureInUse || this.textureBufferPool.anyTextureInUse() || !this.isQuitting) {
            throw new IllegalStateException("Unexpected release.");
        }
        this.yuvConverter.release();
        this.textureBufferPool.dispose();
        GLES20.glDeleteTextures((int)1, (int[])new int[]{this.oesTextureId}, (int)0);
        this.surfaceTexture.release();
        this.eglBase.release();
        this.delayHandler.getLooper().quit();
        this.handler.getLooper().quit();
    }

    public static interface IVideoCapture
    extends VideoSink {
        public void onFrameDropped(int var1);
    }
}

