/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtc2.video;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import io.agora.base.internal.Logging;
import io.agora.rtc2.video.IVideoCapture;
import io.agora.rtc2.video.IVideoCaptureCamera;
import io.agora.rtc2.video.VideoCaptureFormat;

public class VideoCaptureCameraFallbackWrapper
implements IVideoCaptureCamera {
    private static final String TAG = VideoCaptureCameraFallbackWrapper.class.getSimpleName();
    @NonNull
    private IVideoCaptureCamera captuer;
    @NonNull
    private OnCameraFallbackListener fallbackListener;
    private VideoCaptureFormat format;
    @VisibleForTesting
    private IVideoCapture.Events events;

    @Override
    @VisibleForTesting
    public void setEventsCallback(IVideoCapture.Events event) {
        this.events = event;
        this.captuer.setEventsCallback(event);
    }

    VideoCaptureCameraFallbackWrapper(@NonNull IVideoCaptureCamera captuer, @NonNull OnCameraFallbackListener fallbackListener) {
        this.captuer = captuer;
        this.fallbackListener = fallbackListener;
    }

    @Override
    public boolean needFallback() {
        return false;
    }

    @Override
    public VideoCaptureFormat getCaptureFormat() {
        return this.captuer.getCaptureFormat();
    }

    @Override
    public boolean isZoomSupported() {
        return this.captuer.isZoomSupported();
    }

    @Override
    public int setZoom(float zoomValue) {
        return this.captuer.setZoom(zoomValue);
    }

    @Override
    public float getMaxZoom() {
        return this.captuer.getMaxZoom();
    }

    @Override
    public boolean isFocusSupported() {
        return this.captuer.isFocusSupported();
    }

    @Override
    public int setFocus(float x, float y) {
        return this.captuer.setFocus(x, y);
    }

    @Override
    public boolean isAutoFaceFocusSupported() {
        return this.captuer.isAutoFaceFocusSupported();
    }

    @Override
    public int setAutoFaceFocus(boolean enable) {
        return this.captuer.setAutoFaceFocus(enable);
    }

    @Override
    public int setFaceDetection(boolean enable) {
        return this.captuer.setFaceDetection(enable);
    }

    @Override
    public int setVideoStabilityMode(int mode) {
        return this.captuer.setVideoStabilityMode(mode);
    }

    @Override
    public boolean isFaceDetectSupported() {
        return this.captuer.isFaceDetectSupported();
    }

    @Override
    public boolean isTorchSupported() {
        return this.captuer.isTorchSupported();
    }

    @Override
    public int setTorchMode(boolean isOn) {
        return this.captuer.setTorchMode(isOn);
    }

    @Override
    public boolean isExposureSupported() {
        return this.captuer.isExposureSupported();
    }

    @Override
    public int setExposure(float positionXinView, float positionYinView) {
        return this.captuer.setExposure(positionXinView, positionYinView);
    }

    @Override
    public void setPreviewInfo(View view, boolean mirror, int renderMode) {
        this.captuer.setPreviewInfo(view, mirror, renderMode);
    }

    @Override
    public boolean allocate(@NonNull VideoCaptureFormat format) {
        this.format = format;
        if (!this.captuer.allocate(format)) {
            this.captuer.dispose();
            if (this.createFallbackCamera()) {
                return this.captuer.allocate(format);
            }
        }
        return true;
    }

    private boolean createFallbackCamera() {
        if (!this.captuer.needFallback()) {
            return false;
        }
        Logging.w(TAG, "capture fallback to low level camera. ");
        this.captuer = this.fallbackListener.createFallbackCamera();
        this.captuer.setEventsCallback(this.events);
        return true;
    }

    @Override
    public boolean startCaptureMaybeAsync() {
        if (!this.captuer.startCaptureMaybeAsync()) {
            this.captuer.deallocate();
            this.captuer.dispose();
            if (this.createFallbackCamera()) {
                return this.captuer.allocate(this.format) && this.captuer.startCaptureMaybeAsync();
            }
        }
        return true;
    }

    @Override
    public void stopCaptureAndBlockUntilStopped() {
        this.captuer.stopCaptureAndBlockUntilStopped();
    }

    @Override
    public void deallocate() {
        this.captuer.deallocate();
    }

    @Override
    public void dispose() {
        this.captuer.dispose();
    }

    static interface OnCameraFallbackListener {
        public IVideoCaptureCamera createFallbackCamera();
    }
}

