/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm2.internal;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import android.util.Log;
import io.agora.base.internal.BuildConfig;
import io.agora.rtm2.RtmClient;
import io.agora.rtm2.RtmConfig;
import io.agora.rtm2.StreamChannel;
import io.agora.rtm2.internal.StreamChannelImpl;
import java.io.File;
import java.util.HashSet;

public class RtmClientImpl
extends RtmClient {
    private static final String TAG = RtmClientImpl.class.getSimpleName();
    private static boolean sLibLoaded = false;
    static String nativeLibraryName = "agora-rtc-sdk";
    private long mNativeHandle = 0L;
    private HashSet<StreamChannelImpl> mChannels = new HashSet();
    static String nativeLibraryPrefix = "lib";
    static String nativeLibrarySurffix = ".so";

    public static synchronized boolean initializeNativeLibs() {
        return RtmClientImpl.initializeNativeLibs(null);
    }

    public static synchronized boolean initializeNativeLibs(String libPath) {
        if (!sLibLoaded) {
            for (int i = 0; i < BuildConfig.so_list.size(); ++i) {
                sLibLoaded = RtmClientImpl.safeLoadLibrary(libPath, BuildConfig.so_list.get(i));
                if (sLibLoaded) continue;
                return sLibLoaded;
            }
            sLibLoaded = RtmClientImpl.safeLoadLibrary(libPath, nativeLibraryName);
        }
        return sLibLoaded;
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    private static boolean safeLoadLibrary(String path, String name) {
        boolean loaded = true;
        try {
            if (TextUtils.isEmpty((CharSequence)path)) {
                System.loadLibrary(name);
            } else {
                System.load(RtmClientImpl.getNativeLibFullPath(path, name));
            }
        }
        catch (SecurityException e) {
            loaded = false;
        }
        catch (UnsatisfiedLinkError e) {
            loaded = false;
        }
        catch (NullPointerException e) {
            loaded = false;
        }
        catch (Exception e) {
            loaded = false;
        }
        if (!loaded) {
            Log.i((String)TAG, (String)("failed to load library " + name + " from " + path));
        }
        return loaded;
    }

    static String getNativeLibFullPath(String path, String name) {
        String fullName = nativeLibraryPrefix + name + nativeLibrarySurffix;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return fullName;
        }
        return path.endsWith(File.separator) ? path + fullName : path + File.separator + fullName;
    }

    public void removeChannel(StreamChannelImpl channel) {
        if (channel != null) {
            this.mChannels.remove(channel);
        }
    }

    @Override
    public int initialize(RtmConfig config) {
        if (config == null || config.mEventHandler == null || config.mUserId == null || TextUtils.isEmpty((CharSequence)config.mUserId)) {
            return -2;
        }
        if (config.mAppId == null || TextUtils.isEmpty((CharSequence)config.mAppId)) {
            return -101;
        }
        if (this.mNativeHandle != 0L) {
            return 0;
        }
        this.mNativeHandle = this.nativeObjectInit();
        if (this.mNativeHandle == 0L) {
            return -1;
        }
        return this.nativeInitialize(this.mNativeHandle, config);
    }

    @Override
    protected int releaseClient() {
        if (this.mNativeHandle != 0L) {
            for (StreamChannelImpl channel : this.mChannels) {
                if (channel == null) continue;
                channel.release();
            }
            RtmClientImpl.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        this.mChannels.clear();
        return 0;
    }

    @Override
    public synchronized StreamChannel createStreamChannel(String channelName) throws RuntimeException {
        if (this.mNativeHandle == 0L) {
            return null;
        }
        for (StreamChannelImpl channel : this.mChannels) {
            if (channel == null || !channel.getChannelName().equals(channelName)) continue;
            return channel;
        }
        long handle = this.nativeCreateStreamChannel(this.mNativeHandle, channelName);
        if (handle == 0L) {
            return null;
        }
        StreamChannelImpl channel = new StreamChannelImpl(handle);
        this.mChannels.add(channel);
        channel.attach(this);
        return channel;
    }

    private native long nativeObjectInit();

    private static native int nativeDestroy(long var0);

    private native int nativeInitialize(long var1, RtmConfig var3);

    private native long nativeCreateStreamChannel(long var1, String var3);
}

